// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Build Auth Token.
 */
@Immutable
public final class BuildTokenInner implements JsonSerializable<BuildTokenInner> {
    /*
     * Authentication token.
     */
    private String token;

    /*
     * Token expiration date.
     */
    private OffsetDateTime expires;

    /**
     * Creates an instance of BuildTokenInner class.
     */
    public BuildTokenInner() {
    }

    /**
     * Get the token property: Authentication token.
     * 
     * @return the token value.
     */
    public String token() {
        return this.token;
    }

    /**
     * Get the expires property: Token expiration date.
     * 
     * @return the expires value.
     */
    public OffsetDateTime expires() {
        return this.expires;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildTokenInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildTokenInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildTokenInner.
     */
    public static BuildTokenInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildTokenInner deserializedBuildTokenInner = new BuildTokenInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("token".equals(fieldName)) {
                    deserializedBuildTokenInner.token = reader.getString();
                } else if ("expires".equals(fieldName)) {
                    deserializedBuildTokenInner.expires = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildTokenInner;
        });
    }
}
