// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import java.io.IOException;
import java.util.List;

/**
 * The builder properties.
 */
@Fluent
public final class BuilderProperties implements JsonSerializable<BuilderProperties> {
    /*
     * Provisioning state of a builder resource.
     */
    private BuilderProvisioningState provisioningState;

    /*
     * Resource ID of the container apps environment that the builder is associated with.
     */
    private String environmentId;

    /*
     * List of mappings of container registries and the managed identity used to connect to it.
     */
    private List<ContainerRegistry> containerRegistries;

    /**
     * Creates an instance of BuilderProperties class.
     */
    public BuilderProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of a builder resource.
     * 
     * @return the provisioningState value.
     */
    public BuilderProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the environmentId property: Resource ID of the container apps environment that the builder is associated
     * with.
     * 
     * @return the environmentId value.
     */
    public String environmentId() {
        return this.environmentId;
    }

    /**
     * Set the environmentId property: Resource ID of the container apps environment that the builder is associated
     * with.
     * 
     * @param environmentId the environmentId value to set.
     * @return the BuilderProperties object itself.
     */
    public BuilderProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    /**
     * Get the containerRegistries property: List of mappings of container registries and the managed identity used to
     * connect to it.
     * 
     * @return the containerRegistries value.
     */
    public List<ContainerRegistry> containerRegistries() {
        return this.containerRegistries;
    }

    /**
     * Set the containerRegistries property: List of mappings of container registries and the managed identity used to
     * connect to it.
     * 
     * @param containerRegistries the containerRegistries value to set.
     * @return the BuilderProperties object itself.
     */
    public BuilderProperties withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.containerRegistries = containerRegistries;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (environmentId() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property environmentId in model BuilderProperties"));
        }
        if (containerRegistries() != null) {
            containerRegistries().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BuilderProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeArrayField("containerRegistries", this.containerRegistries,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuilderProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuilderProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BuilderProperties.
     */
    public static BuilderProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuilderProperties deserializedBuilderProperties = new BuilderProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("environmentId".equals(fieldName)) {
                    deserializedBuilderProperties.environmentId = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedBuilderProperties.provisioningState
                        = BuilderProvisioningState.fromString(reader.getString());
                } else if ("containerRegistries".equals(fieldName)) {
                    List<ContainerRegistry> containerRegistries
                        = reader.readArray(reader1 -> ContainerRegistry.fromJson(reader1));
                    deserializedBuilderProperties.containerRegistries = containerRegistries;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuilderProperties;
        });
    }
}
