// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import java.io.IOException;
import java.util.Map;

/**
 * An environment for Kubernetes cluster specialized for web workloads by Azure App Service.
 */
@Fluent
public final class ConnectedEnvironmentInner extends Resource {
    /*
     * The complex type of the extended location.
     */
    private ExtendedLocation extendedLocation;

    /*
     * ConnectedEnvironment resource specific properties
     */
    private ConnectedEnvironmentProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ConnectedEnvironmentInner class.
     */
    public ConnectedEnvironmentInner() {
    }

    /**
     * Get the extendedLocation property: The complex type of the extended location.
     * 
     * @return the extendedLocation value.
     */
    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    /**
     * Set the extendedLocation property: The complex type of the extended location.
     * 
     * @param extendedLocation the extendedLocation value to set.
     * @return the ConnectedEnvironmentInner object itself.
     */
    public ConnectedEnvironmentInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    /**
     * Get the innerProperties property: ConnectedEnvironment resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private ConnectedEnvironmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectedEnvironmentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectedEnvironmentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Kubernetes Environment.
     * 
     * @return the provisioningState value.
     */
    public ConnectedEnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the deploymentErrors property: Any errors that occurred during deployment or deployment validation.
     * 
     * @return the deploymentErrors value.
     */
    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    /**
     * Get the defaultDomain property: Default Domain Name for the cluster.
     * 
     * @return the defaultDomain value.
     */
    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    /**
     * Get the staticIp property: Static IP of the connectedEnvironment.
     * 
     * @return the staticIp value.
     */
    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    /**
     * Set the staticIp property: Static IP of the connectedEnvironment.
     * 
     * @param staticIp the staticIp value to set.
     * @return the ConnectedEnvironmentInner object itself.
     */
    public ConnectedEnvironmentInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedEnvironmentProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    /**
     * Get the daprAIConnectionString property: Application Insights connection string used by Dapr to export Service to
     * Service communication telemetry.
     * 
     * @return the daprAIConnectionString value.
     */
    public String daprAIConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().daprAIConnectionString();
    }

    /**
     * Set the daprAIConnectionString property: Application Insights connection string used by Dapr to export Service to
     * Service communication telemetry.
     * 
     * @param daprAIConnectionString the daprAIConnectionString value to set.
     * @return the ConnectedEnvironmentInner object itself.
     */
    public ConnectedEnvironmentInner withDaprAIConnectionString(String daprAIConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedEnvironmentProperties();
        }
        this.innerProperties().withDaprAIConnectionString(daprAIConnectionString);
        return this;
    }

    /**
     * Get the customDomainConfiguration property: Custom domain configuration for the environment.
     * 
     * @return the customDomainConfiguration value.
     */
    public CustomDomainConfiguration customDomainConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomainConfiguration();
    }

    /**
     * Set the customDomainConfiguration property: Custom domain configuration for the environment.
     * 
     * @param customDomainConfiguration the customDomainConfiguration value to set.
     * @return the ConnectedEnvironmentInner object itself.
     */
    public ConnectedEnvironmentInner
        withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedEnvironmentProperties();
        }
        this.innerProperties().withCustomDomainConfiguration(customDomainConfiguration);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extendedLocation() != null) {
            extendedLocation().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedEnvironmentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedEnvironmentInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectedEnvironmentInner.
     */
    public static ConnectedEnvironmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedEnvironmentInner deserializedConnectedEnvironmentInner = new ConnectedEnvironmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedConnectedEnvironmentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedConnectedEnvironmentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedConnectedEnvironmentInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedConnectedEnvironmentInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedConnectedEnvironmentInner.withTags(tags);
                } else if ("extendedLocation".equals(fieldName)) {
                    deserializedConnectedEnvironmentInner.extendedLocation = ExtendedLocation.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedConnectedEnvironmentInner.innerProperties
                        = ConnectedEnvironmentProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedConnectedEnvironmentInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedEnvironmentInner;
        });
    }
}
