// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStorageProperties;
import java.io.IOException;

/**
 * Storage resource for connectedEnvironment.
 */
@Fluent
public final class ConnectedEnvironmentStorageInner extends ProxyResource {
    /*
     * Storage properties
     */
    private ConnectedEnvironmentStorageProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ConnectedEnvironmentStorageInner class.
     */
    public ConnectedEnvironmentStorageInner() {
    }

    /**
     * Get the properties property: Storage properties.
     * 
     * @return the properties value.
     */
    public ConnectedEnvironmentStorageProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Storage properties.
     * 
     * @param properties the properties value to set.
     * @return the ConnectedEnvironmentStorageInner object itself.
     */
    public ConnectedEnvironmentStorageInner withProperties(ConnectedEnvironmentStorageProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedEnvironmentStorageInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedEnvironmentStorageInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectedEnvironmentStorageInner.
     */
    public static ConnectedEnvironmentStorageInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedEnvironmentStorageInner deserializedConnectedEnvironmentStorageInner
                = new ConnectedEnvironmentStorageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageInner.properties
                        = ConnectedEnvironmentStorageProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedEnvironmentStorageInner;
        });
    }
}
