// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppPropertiesPatchingConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appcontainers.models.Template;
import java.io.IOException;
import java.util.List;

/**
 * ContainerApp resource specific properties.
 */
@Fluent
public final class ContainerAppProperties implements JsonSerializable<ContainerAppProperties> {
    /*
     * Provisioning state of the Container App.
     */
    private ContainerAppProvisioningState provisioningState;

    /*
     * Deprecated. Resource ID of the Container App's environment.
     */
    private String managedEnvironmentId;

    /*
     * Resource ID of environment.
     */
    private String environmentId;

    /*
     * Workload profile name to pin for container app execution.
     */
    private String workloadProfileName;

    /*
     * Container App auto patch configuration.
     */
    private ContainerAppPropertiesPatchingConfiguration patchingConfiguration;

    /*
     * Name of the latest revision of the Container App.
     */
    private String latestRevisionName;

    /*
     * Name of the latest ready revision of the Container App.
     */
    private String latestReadyRevisionName;

    /*
     * Fully Qualified Domain Name of the latest revision of the Container App.
     */
    private String latestRevisionFqdn;

    /*
     * Id used to verify domain name ownership
     */
    private String customDomainVerificationId;

    /*
     * Non versioned Container App configuration properties.
     */
    private Configuration configuration;

    /*
     * Container App versioned application definition.
     */
    private Template template;

    /*
     * Outbound IP Addresses for container app.
     */
    private List<String> outboundIpAddresses;

    /*
     * The endpoint of the eventstream of the container app.
     */
    private String eventStreamEndpoint;

    /**
     * Creates an instance of ContainerAppProperties class.
     */
    public ContainerAppProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the Container App.
     * 
     * @return the provisioningState value.
     */
    public ContainerAppProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the managedEnvironmentId property: Deprecated. Resource ID of the Container App's environment.
     * 
     * @return the managedEnvironmentId value.
     */
    public String managedEnvironmentId() {
        return this.managedEnvironmentId;
    }

    /**
     * Set the managedEnvironmentId property: Deprecated. Resource ID of the Container App's environment.
     * 
     * @param managedEnvironmentId the managedEnvironmentId value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withManagedEnvironmentId(String managedEnvironmentId) {
        this.managedEnvironmentId = managedEnvironmentId;
        return this;
    }

    /**
     * Get the environmentId property: Resource ID of environment.
     * 
     * @return the environmentId value.
     */
    public String environmentId() {
        return this.environmentId;
    }

    /**
     * Set the environmentId property: Resource ID of environment.
     * 
     * @param environmentId the environmentId value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    /**
     * Get the workloadProfileName property: Workload profile name to pin for container app execution.
     * 
     * @return the workloadProfileName value.
     */
    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    /**
     * Set the workloadProfileName property: Workload profile name to pin for container app execution.
     * 
     * @param workloadProfileName the workloadProfileName value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    /**
     * Get the patchingConfiguration property: Container App auto patch configuration.
     * 
     * @return the patchingConfiguration value.
     */
    public ContainerAppPropertiesPatchingConfiguration patchingConfiguration() {
        return this.patchingConfiguration;
    }

    /**
     * Set the patchingConfiguration property: Container App auto patch configuration.
     * 
     * @param patchingConfiguration the patchingConfiguration value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties
        withPatchingConfiguration(ContainerAppPropertiesPatchingConfiguration patchingConfiguration) {
        this.patchingConfiguration = patchingConfiguration;
        return this;
    }

    /**
     * Get the latestRevisionName property: Name of the latest revision of the Container App.
     * 
     * @return the latestRevisionName value.
     */
    public String latestRevisionName() {
        return this.latestRevisionName;
    }

    /**
     * Get the latestReadyRevisionName property: Name of the latest ready revision of the Container App.
     * 
     * @return the latestReadyRevisionName value.
     */
    public String latestReadyRevisionName() {
        return this.latestReadyRevisionName;
    }

    /**
     * Get the latestRevisionFqdn property: Fully Qualified Domain Name of the latest revision of the Container App.
     * 
     * @return the latestRevisionFqdn value.
     */
    public String latestRevisionFqdn() {
        return this.latestRevisionFqdn;
    }

    /**
     * Get the customDomainVerificationId property: Id used to verify domain name ownership.
     * 
     * @return the customDomainVerificationId value.
     */
    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    /**
     * Get the configuration property: Non versioned Container App configuration properties.
     * 
     * @return the configuration value.
     */
    public Configuration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Non versioned Container App configuration properties.
     * 
     * @param configuration the configuration value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the template property: Container App versioned application definition.
     * 
     * @return the template value.
     */
    public Template template() {
        return this.template;
    }

    /**
     * Set the template property: Container App versioned application definition.
     * 
     * @param template the template value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withTemplate(Template template) {
        this.template = template;
        return this;
    }

    /**
     * Get the outboundIpAddresses property: Outbound IP Addresses for container app.
     * 
     * @return the outboundIpAddresses value.
     */
    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    /**
     * Get the eventStreamEndpoint property: The endpoint of the eventstream of the container app.
     * 
     * @return the eventStreamEndpoint value.
     */
    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (patchingConfiguration() != null) {
            patchingConfiguration().validate();
        }
        if (configuration() != null) {
            configuration().validate();
        }
        if (template() != null) {
            template().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("managedEnvironmentId", this.managedEnvironmentId);
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeStringField("workloadProfileName", this.workloadProfileName);
        jsonWriter.writeJsonField("patchingConfiguration", this.patchingConfiguration);
        jsonWriter.writeJsonField("configuration", this.configuration);
        jsonWriter.writeJsonField("template", this.template);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerAppProperties.
     */
    public static ContainerAppProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppProperties deserializedContainerAppProperties = new ContainerAppProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerAppProperties.provisioningState
                        = ContainerAppProvisioningState.fromString(reader.getString());
                } else if ("managedEnvironmentId".equals(fieldName)) {
                    deserializedContainerAppProperties.managedEnvironmentId = reader.getString();
                } else if ("environmentId".equals(fieldName)) {
                    deserializedContainerAppProperties.environmentId = reader.getString();
                } else if ("workloadProfileName".equals(fieldName)) {
                    deserializedContainerAppProperties.workloadProfileName = reader.getString();
                } else if ("patchingConfiguration".equals(fieldName)) {
                    deserializedContainerAppProperties.patchingConfiguration
                        = ContainerAppPropertiesPatchingConfiguration.fromJson(reader);
                } else if ("latestRevisionName".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionName = reader.getString();
                } else if ("latestReadyRevisionName".equals(fieldName)) {
                    deserializedContainerAppProperties.latestReadyRevisionName = reader.getString();
                } else if ("latestRevisionFqdn".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionFqdn = reader.getString();
                } else if ("customDomainVerificationId".equals(fieldName)) {
                    deserializedContainerAppProperties.customDomainVerificationId = reader.getString();
                } else if ("configuration".equals(fieldName)) {
                    deserializedContainerAppProperties.configuration = Configuration.fromJson(reader);
                } else if ("template".equals(fieldName)) {
                    deserializedContainerAppProperties.template = Template.fromJson(reader);
                } else if ("outboundIpAddresses".equals(fieldName)) {
                    List<String> outboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerAppProperties.outboundIpAddresses = outboundIpAddresses;
                } else if ("eventStreamEndpoint".equals(fieldName)) {
                    deserializedContainerAppProperties.eventStreamEndpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppProperties;
        });
    }
}
