// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

/**
 * The ContainerAppBuild properties.
 */
@Immutable
public final class ContainerAppsBuildProperties implements JsonSerializable<ContainerAppsBuildProperties> {
    /*
     * Build provisioning state.
     */
    private BuildProvisioningState provisioningState;

    /*
     * Status of the build once it has been provisioned.
     */
    private BuildStatus buildStatus;

    /*
     * Container registry that the final image will be uploaded to.
     */
    private ContainerRegistryWithCustomImage destinationContainerRegistry;

    /*
     * Configuration of the build.
     */
    private ContainerAppsBuildConfiguration configuration;

    /*
     * Endpoint from which the build logs can be streamed.
     */
    private String logStreamEndpoint;

    /**
     * Creates an instance of ContainerAppsBuildProperties class.
     */
    public ContainerAppsBuildProperties() {
    }

    /**
     * Get the provisioningState property: Build provisioning state.
     * 
     * @return the provisioningState value.
     */
    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the buildStatus property: Status of the build once it has been provisioned.
     * 
     * @return the buildStatus value.
     */
    public BuildStatus buildStatus() {
        return this.buildStatus;
    }

    /**
     * Get the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @return the destinationContainerRegistry value.
     */
    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.destinationContainerRegistry;
    }

    /**
     * Get the configuration property: Configuration of the build.
     * 
     * @return the configuration value.
     */
    public ContainerAppsBuildConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Get the logStreamEndpoint property: Endpoint from which the build logs can be streamed.
     * 
     * @return the logStreamEndpoint value.
     */
    public String logStreamEndpoint() {
        return this.logStreamEndpoint;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destinationContainerRegistry() != null) {
            destinationContainerRegistry().validate();
        }
        if (configuration() != null) {
            configuration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppsBuildProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppsBuildProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerAppsBuildProperties.
     */
    public static ContainerAppsBuildProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppsBuildProperties deserializedContainerAppsBuildProperties = new ContainerAppsBuildProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.provisioningState
                        = BuildProvisioningState.fromString(reader.getString());
                } else if ("buildStatus".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.buildStatus = BuildStatus.fromString(reader.getString());
                } else if ("destinationContainerRegistry".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.destinationContainerRegistry
                        = ContainerRegistryWithCustomImage.fromJson(reader);
                } else if ("configuration".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.configuration
                        = ContainerAppsBuildConfiguration.fromJson(reader);
                } else if ("logStreamEndpoint".equals(fieldName)) {
                    deserializedContainerAppsBuildProperties.logStreamEndpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppsBuildProperties;
        });
    }
}
