// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

/**
 * Information pertaining to an individual build.
 */
@Immutable
public final class ContainerAppsBuildResourceInner extends ProxyResource {
    /*
     * The resource-specific properties for this resource.
     */
    private ContainerAppsBuildProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ContainerAppsBuildResourceInner class.
     */
    public ContainerAppsBuildResourceInner() {
    }

    /**
     * Get the innerProperties property: The resource-specific properties for this resource.
     * 
     * @return the innerProperties value.
     */
    private ContainerAppsBuildProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the provisioningState property: Build provisioning state.
     * 
     * @return the provisioningState value.
     */
    public BuildProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the buildStatus property: Status of the build once it has been provisioned.
     * 
     * @return the buildStatus value.
     */
    public BuildStatus buildStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().buildStatus();
    }

    /**
     * Get the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @return the destinationContainerRegistry value.
     */
    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationContainerRegistry();
    }

    /**
     * Get the configuration property: Configuration of the build.
     * 
     * @return the configuration value.
     */
    public ContainerAppsBuildConfiguration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    /**
     * Get the logStreamEndpoint property: Endpoint from which the build logs can be streamed.
     * 
     * @return the logStreamEndpoint value.
     */
    public String logStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().logStreamEndpoint();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppsBuildResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppsBuildResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerAppsBuildResourceInner.
     */
    public static ContainerAppsBuildResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppsBuildResourceInner deserializedContainerAppsBuildResourceInner
                = new ContainerAppsBuildResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.innerProperties
                        = ContainerAppsBuildProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppsBuildResourceInner;
        });
    }
}
