// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprComponentServiceBinding;
import com.azure.resourcemanager.appcontainers.models.DaprMetadata;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.io.IOException;
import java.util.List;

/**
 * Dapr Component resource specific properties.
 */
@Fluent
public final class DaprComponentProperties implements JsonSerializable<DaprComponentProperties> {
    /*
     * Component type
     */
    private String componentType;

    /*
     * Component version
     */
    private String version;

    /*
     * Boolean describing if the component errors are ignores
     */
    private Boolean ignoreErrors;

    /*
     * Initialization timeout
     */
    private String initTimeout;

    /*
     * Collection of secrets used by a Dapr component
     */
    private List<Secret> secrets;

    /*
     * Name of a Dapr component to retrieve component secrets from
     */
    private String secretStoreComponent;

    /*
     * Component metadata
     */
    private List<DaprMetadata> metadata;

    /*
     * Names of container apps that can use this Dapr component
     */
    private List<String> scopes;

    /*
     * List of container app services that are bound to the Dapr component
     */
    private List<DaprComponentServiceBinding> serviceComponentBind;

    /**
     * Creates an instance of DaprComponentProperties class.
     */
    public DaprComponentProperties() {
    }

    /**
     * Get the componentType property: Component type.
     * 
     * @return the componentType value.
     */
    public String componentType() {
        return this.componentType;
    }

    /**
     * Set the componentType property: Component type.
     * 
     * @param componentType the componentType value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withComponentType(String componentType) {
        this.componentType = componentType;
        return this;
    }

    /**
     * Get the version property: Component version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: Component version.
     * 
     * @param version the version value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the ignoreErrors property: Boolean describing if the component errors are ignores.
     * 
     * @return the ignoreErrors value.
     */
    public Boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    /**
     * Set the ignoreErrors property: Boolean describing if the component errors are ignores.
     * 
     * @param ignoreErrors the ignoreErrors value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withIgnoreErrors(Boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        return this;
    }

    /**
     * Get the initTimeout property: Initialization timeout.
     * 
     * @return the initTimeout value.
     */
    public String initTimeout() {
        return this.initTimeout;
    }

    /**
     * Set the initTimeout property: Initialization timeout.
     * 
     * @param initTimeout the initTimeout value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withInitTimeout(String initTimeout) {
        this.initTimeout = initTimeout;
        return this;
    }

    /**
     * Get the secrets property: Collection of secrets used by a Dapr component.
     * 
     * @return the secrets value.
     */
    public List<Secret> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Collection of secrets used by a Dapr component.
     * 
     * @param secrets the secrets value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withSecrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the secretStoreComponent property: Name of a Dapr component to retrieve component secrets from.
     * 
     * @return the secretStoreComponent value.
     */
    public String secretStoreComponent() {
        return this.secretStoreComponent;
    }

    /**
     * Set the secretStoreComponent property: Name of a Dapr component to retrieve component secrets from.
     * 
     * @param secretStoreComponent the secretStoreComponent value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withSecretStoreComponent(String secretStoreComponent) {
        this.secretStoreComponent = secretStoreComponent;
        return this;
    }

    /**
     * Get the metadata property: Component metadata.
     * 
     * @return the metadata value.
     */
    public List<DaprMetadata> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Component metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withMetadata(List<DaprMetadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the scopes property: Names of container apps that can use this Dapr component.
     * 
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: Names of container apps that can use this Dapr component.
     * 
     * @param scopes the scopes value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get the serviceComponentBind property: List of container app services that are bound to the Dapr component.
     * 
     * @return the serviceComponentBind value.
     */
    public List<DaprComponentServiceBinding> serviceComponentBind() {
        return this.serviceComponentBind;
    }

    /**
     * Set the serviceComponentBind property: List of container app services that are bound to the Dapr component.
     * 
     * @param serviceComponentBind the serviceComponentBind value to set.
     * @return the DaprComponentProperties object itself.
     */
    public DaprComponentProperties withServiceComponentBind(List<DaprComponentServiceBinding> serviceComponentBind) {
        this.serviceComponentBind = serviceComponentBind;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (secrets() != null) {
            secrets().forEach(e -> e.validate());
        }
        if (metadata() != null) {
            metadata().forEach(e -> e.validate());
        }
        if (serviceComponentBind() != null) {
            serviceComponentBind().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("componentType", this.componentType);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeBooleanField("ignoreErrors", this.ignoreErrors);
        jsonWriter.writeStringField("initTimeout", this.initTimeout);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("secretStoreComponent", this.secretStoreComponent);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("serviceComponentBind", this.serviceComponentBind,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprComponentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprComponentProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DaprComponentProperties.
     */
    public static DaprComponentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponentProperties deserializedDaprComponentProperties = new DaprComponentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("componentType".equals(fieldName)) {
                    deserializedDaprComponentProperties.componentType = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedDaprComponentProperties.version = reader.getString();
                } else if ("ignoreErrors".equals(fieldName)) {
                    deserializedDaprComponentProperties.ignoreErrors = reader.getNullable(JsonReader::getBoolean);
                } else if ("initTimeout".equals(fieldName)) {
                    deserializedDaprComponentProperties.initTimeout = reader.getString();
                } else if ("secrets".equals(fieldName)) {
                    List<Secret> secrets = reader.readArray(reader1 -> Secret.fromJson(reader1));
                    deserializedDaprComponentProperties.secrets = secrets;
                } else if ("secretStoreComponent".equals(fieldName)) {
                    deserializedDaprComponentProperties.secretStoreComponent = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    List<DaprMetadata> metadata = reader.readArray(reader1 -> DaprMetadata.fromJson(reader1));
                    deserializedDaprComponentProperties.metadata = metadata;
                } else if ("scopes".equals(fieldName)) {
                    List<String> scopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedDaprComponentProperties.scopes = scopes;
                } else if ("serviceComponentBind".equals(fieldName)) {
                    List<DaprComponentServiceBinding> serviceComponentBind
                        = reader.readArray(reader1 -> DaprComponentServiceBinding.fromJson(reader1));
                    deserializedDaprComponentProperties.serviceComponentBind = serviceComponentBind;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprComponentProperties;
        });
    }
}
