// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicyConfiguration;
import java.io.IOException;

/**
 * Dapr Component Resiliency Policy.
 */
@Fluent
public final class DaprComponentResiliencyPolicyInner extends ProxyResource {
    /*
     * Dapr Component Resiliency Policy resource specific properties
     */
    private DaprComponentResiliencyPolicyProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of DaprComponentResiliencyPolicyInner class.
     */
    public DaprComponentResiliencyPolicyInner() {
    }

    /**
     * Get the innerProperties property: Dapr Component Resiliency Policy resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private DaprComponentResiliencyPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the inboundPolicy property: The optional inbound component resiliency policy configuration.
     * 
     * @return the inboundPolicy value.
     */
    public DaprComponentResiliencyPolicyConfiguration inboundPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundPolicy();
    }

    /**
     * Set the inboundPolicy property: The optional inbound component resiliency policy configuration.
     * 
     * @param inboundPolicy the inboundPolicy value to set.
     * @return the DaprComponentResiliencyPolicyInner object itself.
     */
    public DaprComponentResiliencyPolicyInner
        withInboundPolicy(DaprComponentResiliencyPolicyConfiguration inboundPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentResiliencyPolicyProperties();
        }
        this.innerProperties().withInboundPolicy(inboundPolicy);
        return this;
    }

    /**
     * Get the outboundPolicy property: The optional outbound component resiliency policy configuration.
     * 
     * @return the outboundPolicy value.
     */
    public DaprComponentResiliencyPolicyConfiguration outboundPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundPolicy();
    }

    /**
     * Set the outboundPolicy property: The optional outbound component resiliency policy configuration.
     * 
     * @param outboundPolicy the outboundPolicy value to set.
     * @return the DaprComponentResiliencyPolicyInner object itself.
     */
    public DaprComponentResiliencyPolicyInner
        withOutboundPolicy(DaprComponentResiliencyPolicyConfiguration outboundPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentResiliencyPolicyProperties();
        }
        this.innerProperties().withOutboundPolicy(outboundPolicy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprComponentResiliencyPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprComponentResiliencyPolicyInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DaprComponentResiliencyPolicyInner.
     */
    public static DaprComponentResiliencyPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponentResiliencyPolicyInner deserializedDaprComponentResiliencyPolicyInner
                = new DaprComponentResiliencyPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyInner.innerProperties
                        = DaprComponentResiliencyPolicyProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprComponentResiliencyPolicyInner;
        });
    }
}
