// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicyConfiguration;
import java.io.IOException;

/**
 * Dapr Component Resiliency Policy resource specific properties.
 */
@Fluent
public final class DaprComponentResiliencyPolicyProperties
    implements JsonSerializable<DaprComponentResiliencyPolicyProperties> {
    /*
     * The optional inbound component resiliency policy configuration
     */
    private DaprComponentResiliencyPolicyConfiguration inboundPolicy;

    /*
     * The optional outbound component resiliency policy configuration
     */
    private DaprComponentResiliencyPolicyConfiguration outboundPolicy;

    /**
     * Creates an instance of DaprComponentResiliencyPolicyProperties class.
     */
    public DaprComponentResiliencyPolicyProperties() {
    }

    /**
     * Get the inboundPolicy property: The optional inbound component resiliency policy configuration.
     * 
     * @return the inboundPolicy value.
     */
    public DaprComponentResiliencyPolicyConfiguration inboundPolicy() {
        return this.inboundPolicy;
    }

    /**
     * Set the inboundPolicy property: The optional inbound component resiliency policy configuration.
     * 
     * @param inboundPolicy the inboundPolicy value to set.
     * @return the DaprComponentResiliencyPolicyProperties object itself.
     */
    public DaprComponentResiliencyPolicyProperties
        withInboundPolicy(DaprComponentResiliencyPolicyConfiguration inboundPolicy) {
        this.inboundPolicy = inboundPolicy;
        return this;
    }

    /**
     * Get the outboundPolicy property: The optional outbound component resiliency policy configuration.
     * 
     * @return the outboundPolicy value.
     */
    public DaprComponentResiliencyPolicyConfiguration outboundPolicy() {
        return this.outboundPolicy;
    }

    /**
     * Set the outboundPolicy property: The optional outbound component resiliency policy configuration.
     * 
     * @param outboundPolicy the outboundPolicy value to set.
     * @return the DaprComponentResiliencyPolicyProperties object itself.
     */
    public DaprComponentResiliencyPolicyProperties
        withOutboundPolicy(DaprComponentResiliencyPolicyConfiguration outboundPolicy) {
        this.outboundPolicy = outboundPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (inboundPolicy() != null) {
            inboundPolicy().validate();
        }
        if (outboundPolicy() != null) {
            outboundPolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("inboundPolicy", this.inboundPolicy);
        jsonWriter.writeJsonField("outboundPolicy", this.outboundPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprComponentResiliencyPolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprComponentResiliencyPolicyProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DaprComponentResiliencyPolicyProperties.
     */
    public static DaprComponentResiliencyPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponentResiliencyPolicyProperties deserializedDaprComponentResiliencyPolicyProperties
                = new DaprComponentResiliencyPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inboundPolicy".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyProperties.inboundPolicy
                        = DaprComponentResiliencyPolicyConfiguration.fromJson(reader);
                } else if ("outboundPolicy".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyProperties.outboundPolicy
                        = DaprComponentResiliencyPolicyConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprComponentResiliencyPolicyProperties;
        });
    }
}
