// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionBulkSubscribeOptions;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRoutes;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Dapr PubSub Event Subscription.
 */
@Fluent
public final class DaprSubscriptionInner extends ProxyResource {
    /*
     * Dapr PubSub Event Subscription resource specific properties
     */
    private DaprSubscriptionProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of DaprSubscriptionInner class.
     */
    public DaprSubscriptionInner() {
    }

    /**
     * Get the innerProperties property: Dapr PubSub Event Subscription resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private DaprSubscriptionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the pubsubName property: Dapr PubSub component name.
     * 
     * @return the pubsubName value.
     */
    public String pubsubName() {
        return this.innerProperties() == null ? null : this.innerProperties().pubsubName();
    }

    /**
     * Set the pubsubName property: Dapr PubSub component name.
     * 
     * @param pubsubName the pubsubName value to set.
     * @return the DaprSubscriptionInner object itself.
     */
    public DaprSubscriptionInner withPubsubName(String pubsubName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withPubsubName(pubsubName);
        return this;
    }

    /**
     * Get the topic property: Topic name.
     * 
     * @return the topic value.
     */
    public String topic() {
        return this.innerProperties() == null ? null : this.innerProperties().topic();
    }

    /**
     * Set the topic property: Topic name.
     * 
     * @param topic the topic value to set.
     * @return the DaprSubscriptionInner object itself.
     */
    public DaprSubscriptionInner withTopic(String topic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withTopic(topic);
        return this;
    }

    /**
     * Get the deadLetterTopic property: Deadletter topic name.
     * 
     * @return the deadLetterTopic value.
     */
    public String deadLetterTopic() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetterTopic();
    }

    /**
     * Set the deadLetterTopic property: Deadletter topic name.
     * 
     * @param deadLetterTopic the deadLetterTopic value to set.
     * @return the DaprSubscriptionInner object itself.
     */
    public DaprSubscriptionInner withDeadLetterTopic(String deadLetterTopic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withDeadLetterTopic(deadLetterTopic);
        return this;
    }

    /**
     * Get the routes property: Subscription routes.
     * 
     * @return the routes value.
     */
    public DaprSubscriptionRoutes routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    /**
     * Set the routes property: Subscription routes.
     * 
     * @param routes the routes value to set.
     * @return the DaprSubscriptionInner object itself.
     */
    public DaprSubscriptionInner withRoutes(DaprSubscriptionRoutes routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    /**
     * Get the scopes property: Application scopes to restrict the subscription to specific apps.
     * 
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    /**
     * Set the scopes property: Application scopes to restrict the subscription to specific apps.
     * 
     * @param scopes the scopes value to set.
     * @return the DaprSubscriptionInner object itself.
     */
    public DaprSubscriptionInner withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    /**
     * Get the metadata property: Subscription metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    /**
     * Set the metadata property: Subscription metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the DaprSubscriptionInner object itself.
     */
    public DaprSubscriptionInner withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    /**
     * Get the bulkSubscribe property: Bulk subscription options.
     * 
     * @return the bulkSubscribe value.
     */
    public DaprSubscriptionBulkSubscribeOptions bulkSubscribe() {
        return this.innerProperties() == null ? null : this.innerProperties().bulkSubscribe();
    }

    /**
     * Set the bulkSubscribe property: Bulk subscription options.
     * 
     * @param bulkSubscribe the bulkSubscribe value to set.
     * @return the DaprSubscriptionInner object itself.
     */
    public DaprSubscriptionInner withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withBulkSubscribe(bulkSubscribe);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprSubscriptionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprSubscriptionInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DaprSubscriptionInner.
     */
    public static DaprSubscriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprSubscriptionInner deserializedDaprSubscriptionInner = new DaprSubscriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.innerProperties = DaprSubscriptionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprSubscriptionInner;
        });
    }
}
