// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionBulkSubscribeOptions;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRoutes;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Dapr PubSub Event Subscription resource specific properties.
 */
@Fluent
public final class DaprSubscriptionProperties implements JsonSerializable<DaprSubscriptionProperties> {
    /*
     * Dapr PubSub component name
     */
    private String pubsubName;

    /*
     * Topic name
     */
    private String topic;

    /*
     * Deadletter topic name
     */
    private String deadLetterTopic;

    /*
     * Subscription routes
     */
    private DaprSubscriptionRoutes routes;

    /*
     * Application scopes to restrict the subscription to specific apps.
     */
    private List<String> scopes;

    /*
     * Subscription metadata
     */
    private Map<String, String> metadata;

    /*
     * Bulk subscription options
     */
    private DaprSubscriptionBulkSubscribeOptions bulkSubscribe;

    /**
     * Creates an instance of DaprSubscriptionProperties class.
     */
    public DaprSubscriptionProperties() {
    }

    /**
     * Get the pubsubName property: Dapr PubSub component name.
     * 
     * @return the pubsubName value.
     */
    public String pubsubName() {
        return this.pubsubName;
    }

    /**
     * Set the pubsubName property: Dapr PubSub component name.
     * 
     * @param pubsubName the pubsubName value to set.
     * @return the DaprSubscriptionProperties object itself.
     */
    public DaprSubscriptionProperties withPubsubName(String pubsubName) {
        this.pubsubName = pubsubName;
        return this;
    }

    /**
     * Get the topic property: Topic name.
     * 
     * @return the topic value.
     */
    public String topic() {
        return this.topic;
    }

    /**
     * Set the topic property: Topic name.
     * 
     * @param topic the topic value to set.
     * @return the DaprSubscriptionProperties object itself.
     */
    public DaprSubscriptionProperties withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    /**
     * Get the deadLetterTopic property: Deadletter topic name.
     * 
     * @return the deadLetterTopic value.
     */
    public String deadLetterTopic() {
        return this.deadLetterTopic;
    }

    /**
     * Set the deadLetterTopic property: Deadletter topic name.
     * 
     * @param deadLetterTopic the deadLetterTopic value to set.
     * @return the DaprSubscriptionProperties object itself.
     */
    public DaprSubscriptionProperties withDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
        return this;
    }

    /**
     * Get the routes property: Subscription routes.
     * 
     * @return the routes value.
     */
    public DaprSubscriptionRoutes routes() {
        return this.routes;
    }

    /**
     * Set the routes property: Subscription routes.
     * 
     * @param routes the routes value to set.
     * @return the DaprSubscriptionProperties object itself.
     */
    public DaprSubscriptionProperties withRoutes(DaprSubscriptionRoutes routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Get the scopes property: Application scopes to restrict the subscription to specific apps.
     * 
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: Application scopes to restrict the subscription to specific apps.
     * 
     * @param scopes the scopes value to set.
     * @return the DaprSubscriptionProperties object itself.
     */
    public DaprSubscriptionProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get the metadata property: Subscription metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Subscription metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the DaprSubscriptionProperties object itself.
     */
    public DaprSubscriptionProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the bulkSubscribe property: Bulk subscription options.
     * 
     * @return the bulkSubscribe value.
     */
    public DaprSubscriptionBulkSubscribeOptions bulkSubscribe() {
        return this.bulkSubscribe;
    }

    /**
     * Set the bulkSubscribe property: Bulk subscription options.
     * 
     * @param bulkSubscribe the bulkSubscribe value to set.
     * @return the DaprSubscriptionProperties object itself.
     */
    public DaprSubscriptionProperties withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe) {
        this.bulkSubscribe = bulkSubscribe;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routes() != null) {
            routes().validate();
        }
        if (bulkSubscribe() != null) {
            bulkSubscribe().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("pubsubName", this.pubsubName);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeStringField("deadLetterTopic", this.deadLetterTopic);
        jsonWriter.writeJsonField("routes", this.routes);
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("bulkSubscribe", this.bulkSubscribe);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprSubscriptionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprSubscriptionProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DaprSubscriptionProperties.
     */
    public static DaprSubscriptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprSubscriptionProperties deserializedDaprSubscriptionProperties = new DaprSubscriptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("pubsubName".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.pubsubName = reader.getString();
                } else if ("topic".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.topic = reader.getString();
                } else if ("deadLetterTopic".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.deadLetterTopic = reader.getString();
                } else if ("routes".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.routes = DaprSubscriptionRoutes.fromJson(reader);
                } else if ("scopes".equals(fieldName)) {
                    List<String> scopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedDaprSubscriptionProperties.scopes = scopes;
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedDaprSubscriptionProperties.metadata = metadata;
                } else if ("bulkSubscribe".equals(fieldName)) {
                    deserializedDaprSubscriptionProperties.bulkSubscribe
                        = DaprSubscriptionBulkSubscribeOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprSubscriptionProperties;
        });
    }
}
