// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Diagnostics data collection for a resource.
 */
@Fluent
public final class DiagnosticsCollectionInner implements JsonSerializable<DiagnosticsCollectionInner> {
    /*
     * Collection of diagnostic data.
     */
    private List<DiagnosticsInner> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of DiagnosticsCollectionInner class.
     */
    public DiagnosticsCollectionInner() {
    }

    /**
     * Get the value property: Collection of diagnostic data.
     * 
     * @return the value value.
     */
    public List<DiagnosticsInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of diagnostic data.
     * 
     * @param value the value value to set.
     * @return the DiagnosticsCollectionInner object itself.
     */
    public DiagnosticsCollectionInner withValue(List<DiagnosticsInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model DiagnosticsCollectionInner"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DiagnosticsCollectionInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticsCollectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticsCollectionInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DiagnosticsCollectionInner.
     */
    public static DiagnosticsCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticsCollectionInner deserializedDiagnosticsCollectionInner = new DiagnosticsCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DiagnosticsInner> value = reader.readArray(reader1 -> DiagnosticsInner.fromJson(reader1));
                    deserializedDiagnosticsCollectionInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDiagnosticsCollectionInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticsCollectionInner;
        });
    }
}
