// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentType;
import java.io.IOException;
import java.util.List;

/**
 * .NET Component.
 */
@Fluent
public final class DotNetComponentInner extends ProxyResource {
    /*
     * .NET Component resource specific properties
     */
    private DotNetComponentProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of DotNetComponentInner class.
     */
    public DotNetComponentInner() {
    }

    /**
     * Get the innerProperties property: .NET Component resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private DotNetComponentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the componentType property: Type of the .NET Component.
     * 
     * @return the componentType value.
     */
    public DotNetComponentType componentType() {
        return this.innerProperties() == null ? null : this.innerProperties().componentType();
    }

    /**
     * Set the componentType property: Type of the .NET Component.
     * 
     * @param componentType the componentType value to set.
     * @return the DotNetComponentInner object itself.
     */
    public DotNetComponentInner withComponentType(DotNetComponentType componentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DotNetComponentProperties();
        }
        this.innerProperties().withComponentType(componentType);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the .NET Component.
     * 
     * @return the provisioningState value.
     */
    public DotNetComponentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the configurations property: List of .NET Components configuration properties.
     * 
     * @return the configurations value.
     */
    public List<DotNetComponentConfigurationProperty> configurations() {
        return this.innerProperties() == null ? null : this.innerProperties().configurations();
    }

    /**
     * Set the configurations property: List of .NET Components configuration properties.
     * 
     * @param configurations the configurations value to set.
     * @return the DotNetComponentInner object itself.
     */
    public DotNetComponentInner withConfigurations(List<DotNetComponentConfigurationProperty> configurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DotNetComponentProperties();
        }
        this.innerProperties().withConfigurations(configurations);
        return this;
    }

    /**
     * Get the serviceBinds property: List of .NET Components that are bound to the .NET component.
     * 
     * @return the serviceBinds value.
     */
    public List<DotNetComponentServiceBind> serviceBinds() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBinds();
    }

    /**
     * Set the serviceBinds property: List of .NET Components that are bound to the .NET component.
     * 
     * @param serviceBinds the serviceBinds value to set.
     * @return the DotNetComponentInner object itself.
     */
    public DotNetComponentInner withServiceBinds(List<DotNetComponentServiceBind> serviceBinds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DotNetComponentProperties();
        }
        this.innerProperties().withServiceBinds(serviceBinds);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DotNetComponentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DotNetComponentInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DotNetComponentInner.
     */
    public static DotNetComponentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DotNetComponentInner deserializedDotNetComponentInner = new DotNetComponentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDotNetComponentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDotNetComponentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDotNetComponentInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDotNetComponentInner.innerProperties = DotNetComponentProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedDotNetComponentInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDotNetComponentInner;
        });
    }
}
