// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentType;
import java.io.IOException;
import java.util.List;

/**
 * .NET Component resource specific properties.
 */
@Fluent
public final class DotNetComponentProperties implements JsonSerializable<DotNetComponentProperties> {
    /*
     * Type of the .NET Component.
     */
    private DotNetComponentType componentType;

    /*
     * Provisioning state of the .NET Component.
     */
    private DotNetComponentProvisioningState provisioningState;

    /*
     * List of .NET Components configuration properties
     */
    private List<DotNetComponentConfigurationProperty> configurations;

    /*
     * List of .NET Components that are bound to the .NET component
     */
    private List<DotNetComponentServiceBind> serviceBinds;

    /**
     * Creates an instance of DotNetComponentProperties class.
     */
    public DotNetComponentProperties() {
    }

    /**
     * Get the componentType property: Type of the .NET Component.
     * 
     * @return the componentType value.
     */
    public DotNetComponentType componentType() {
        return this.componentType;
    }

    /**
     * Set the componentType property: Type of the .NET Component.
     * 
     * @param componentType the componentType value to set.
     * @return the DotNetComponentProperties object itself.
     */
    public DotNetComponentProperties withComponentType(DotNetComponentType componentType) {
        this.componentType = componentType;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the .NET Component.
     * 
     * @return the provisioningState value.
     */
    public DotNetComponentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the configurations property: List of .NET Components configuration properties.
     * 
     * @return the configurations value.
     */
    public List<DotNetComponentConfigurationProperty> configurations() {
        return this.configurations;
    }

    /**
     * Set the configurations property: List of .NET Components configuration properties.
     * 
     * @param configurations the configurations value to set.
     * @return the DotNetComponentProperties object itself.
     */
    public DotNetComponentProperties withConfigurations(List<DotNetComponentConfigurationProperty> configurations) {
        this.configurations = configurations;
        return this;
    }

    /**
     * Get the serviceBinds property: List of .NET Components that are bound to the .NET component.
     * 
     * @return the serviceBinds value.
     */
    public List<DotNetComponentServiceBind> serviceBinds() {
        return this.serviceBinds;
    }

    /**
     * Set the serviceBinds property: List of .NET Components that are bound to the .NET component.
     * 
     * @param serviceBinds the serviceBinds value to set.
     * @return the DotNetComponentProperties object itself.
     */
    public DotNetComponentProperties withServiceBinds(List<DotNetComponentServiceBind> serviceBinds) {
        this.serviceBinds = serviceBinds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configurations() != null) {
            configurations().forEach(e -> e.validate());
        }
        if (serviceBinds() != null) {
            serviceBinds().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("componentType", this.componentType == null ? null : this.componentType.toString());
        jsonWriter.writeArrayField("configurations", this.configurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("serviceBinds", this.serviceBinds, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DotNetComponentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DotNetComponentProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DotNetComponentProperties.
     */
    public static DotNetComponentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DotNetComponentProperties deserializedDotNetComponentProperties = new DotNetComponentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("componentType".equals(fieldName)) {
                    deserializedDotNetComponentProperties.componentType
                        = DotNetComponentType.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedDotNetComponentProperties.provisioningState
                        = DotNetComponentProvisioningState.fromString(reader.getString());
                } else if ("configurations".equals(fieldName)) {
                    List<DotNetComponentConfigurationProperty> configurations
                        = reader.readArray(reader1 -> DotNetComponentConfigurationProperty.fromJson(reader1));
                    deserializedDotNetComponentProperties.configurations = configurations;
                } else if ("serviceBinds".equals(fieldName)) {
                    List<DotNetComponentServiceBind> serviceBinds
                        = reader.readArray(reader1 -> DotNetComponentServiceBind.fromJson(reader1));
                    deserializedDotNetComponentProperties.serviceBinds = serviceBinds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDotNetComponentProperties;
        });
    }
}
