// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Type of match to perform.
 */
@Fluent
public final class HeaderMatchMatch implements JsonSerializable<HeaderMatchMatch> {
    /*
     * Exact value of the header
     */
    private String exactMatch;

    /*
     * Prefix value of the header
     */
    private String prefixMatch;

    /*
     * Suffix value of the header
     */
    private String suffixMatch;

    /*
     * Regex value of the header
     */
    private String regexMatch;

    /**
     * Creates an instance of HeaderMatchMatch class.
     */
    public HeaderMatchMatch() {
    }

    /**
     * Get the exactMatch property: Exact value of the header.
     * 
     * @return the exactMatch value.
     */
    public String exactMatch() {
        return this.exactMatch;
    }

    /**
     * Set the exactMatch property: Exact value of the header.
     * 
     * @param exactMatch the exactMatch value to set.
     * @return the HeaderMatchMatch object itself.
     */
    public HeaderMatchMatch withExactMatch(String exactMatch) {
        this.exactMatch = exactMatch;
        return this;
    }

    /**
     * Get the prefixMatch property: Prefix value of the header.
     * 
     * @return the prefixMatch value.
     */
    public String prefixMatch() {
        return this.prefixMatch;
    }

    /**
     * Set the prefixMatch property: Prefix value of the header.
     * 
     * @param prefixMatch the prefixMatch value to set.
     * @return the HeaderMatchMatch object itself.
     */
    public HeaderMatchMatch withPrefixMatch(String prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    /**
     * Get the suffixMatch property: Suffix value of the header.
     * 
     * @return the suffixMatch value.
     */
    public String suffixMatch() {
        return this.suffixMatch;
    }

    /**
     * Set the suffixMatch property: Suffix value of the header.
     * 
     * @param suffixMatch the suffixMatch value to set.
     * @return the HeaderMatchMatch object itself.
     */
    public HeaderMatchMatch withSuffixMatch(String suffixMatch) {
        this.suffixMatch = suffixMatch;
        return this;
    }

    /**
     * Get the regexMatch property: Regex value of the header.
     * 
     * @return the regexMatch value.
     */
    public String regexMatch() {
        return this.regexMatch;
    }

    /**
     * Set the regexMatch property: Regex value of the header.
     * 
     * @param regexMatch the regexMatch value to set.
     * @return the HeaderMatchMatch object itself.
     */
    public HeaderMatchMatch withRegexMatch(String regexMatch) {
        this.regexMatch = regexMatch;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("exactMatch", this.exactMatch);
        jsonWriter.writeStringField("prefixMatch", this.prefixMatch);
        jsonWriter.writeStringField("suffixMatch", this.suffixMatch);
        jsonWriter.writeStringField("regexMatch", this.regexMatch);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HeaderMatchMatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HeaderMatchMatch if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HeaderMatchMatch.
     */
    public static HeaderMatchMatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HeaderMatchMatch deserializedHeaderMatchMatch = new HeaderMatchMatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("exactMatch".equals(fieldName)) {
                    deserializedHeaderMatchMatch.exactMatch = reader.getString();
                } else if ("prefixMatch".equals(fieldName)) {
                    deserializedHeaderMatchMatch.prefixMatch = reader.getString();
                } else if ("suffixMatch".equals(fieldName)) {
                    deserializedHeaderMatchMatch.suffixMatch = reader.getString();
                } else if ("regexMatch".equals(fieldName)) {
                    deserializedHeaderMatchMatch.regexMatch = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHeaderMatchMatch;
        });
    }
}
