// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Container App Job.
 */
@Fluent
public final class JobInner extends Resource {
    /*
     * The complex type of the extended location.
     */
    private ExtendedLocation extendedLocation;

    /*
     * Managed identities needed by a container app job to interact with other Azure services to not maintain any
     * secrets or credentials in code.
     */
    private ManagedServiceIdentity identity;

    /*
     * Container Apps Job resource specific properties.
     */
    private JobProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of JobInner class.
     */
    public JobInner() {
    }

    /**
     * Get the extendedLocation property: The complex type of the extended location.
     * 
     * @return the extendedLocation value.
     */
    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    /**
     * Set the extendedLocation property: The complex type of the extended location.
     * 
     * @param extendedLocation the extendedLocation value to set.
     * @return the JobInner object itself.
     */
    public JobInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    /**
     * Get the identity property: Managed identities needed by a container app job to interact with other Azure services
     * to not maintain any secrets or credentials in code.
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Managed identities needed by a container app job to interact with other Azure services
     * to not maintain any secrets or credentials in code.
     * 
     * @param identity the identity value to set.
     * @return the JobInner object itself.
     */
    public JobInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: Container Apps Job resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private JobProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JobInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JobInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Container Apps Job.
     * 
     * @return the provisioningState value.
     */
    public JobProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the environmentId property: Resource ID of environment.
     * 
     * @return the environmentId value.
     */
    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    /**
     * Set the environmentId property: Resource ID of environment.
     * 
     * @param environmentId the environmentId value to set.
     * @return the JobInner object itself.
     */
    public JobInner withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    /**
     * Get the workloadProfileName property: Workload profile name to pin for container apps job execution.
     * 
     * @return the workloadProfileName value.
     */
    public String workloadProfileName() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadProfileName();
    }

    /**
     * Set the workloadProfileName property: Workload profile name to pin for container apps job execution.
     * 
     * @param workloadProfileName the workloadProfileName value to set.
     * @return the JobInner object itself.
     */
    public JobInner withWorkloadProfileName(String workloadProfileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    /**
     * Get the configuration property: Container Apps Job configuration properties.
     * 
     * @return the configuration value.
     */
    public JobConfiguration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    /**
     * Set the configuration property: Container Apps Job configuration properties.
     * 
     * @param configuration the configuration value to set.
     * @return the JobInner object itself.
     */
    public JobInner withConfiguration(JobConfiguration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    /**
     * Get the template property: Container Apps job definition.
     * 
     * @return the template value.
     */
    public JobTemplate template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    /**
     * Set the template property: Container Apps job definition.
     * 
     * @param template the template value to set.
     * @return the JobInner object itself.
     */
    public JobInner withTemplate(JobTemplate template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    /**
     * Get the outboundIpAddresses property: Outbound IP Addresses of a container apps job.
     * 
     * @return the outboundIpAddresses value.
     */
    public List<String> outboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundIpAddresses();
    }

    /**
     * Get the eventStreamEndpoint property: The endpoint of the eventstream of the container apps job.
     * 
     * @return the eventStreamEndpoint value.
     */
    public String eventStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().eventStreamEndpoint();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extendedLocation() != null) {
            extendedLocation().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the JobInner.
     */
    public static JobInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobInner deserializedJobInner = new JobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedJobInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedJobInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedJobInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedJobInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedJobInner.withTags(tags);
                } else if ("extendedLocation".equals(fieldName)) {
                    deserializedJobInner.extendedLocation = ExtendedLocation.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedJobInner.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedJobInner.innerProperties = JobProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedJobInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobInner;
        });
    }
}
