// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import java.io.IOException;
import java.util.List;

/**
 * Container Apps Job resource specific properties.
 */
@Fluent
public final class JobProperties implements JsonSerializable<JobProperties> {
    /*
     * Provisioning state of the Container Apps Job.
     */
    private JobProvisioningState provisioningState;

    /*
     * Resource ID of environment.
     */
    private String environmentId;

    /*
     * Workload profile name to pin for container apps job execution.
     */
    private String workloadProfileName;

    /*
     * Container Apps Job configuration properties.
     */
    private JobConfiguration configuration;

    /*
     * Container Apps job definition.
     */
    private JobTemplate template;

    /*
     * Outbound IP Addresses of a container apps job.
     */
    private List<String> outboundIpAddresses;

    /*
     * The endpoint of the eventstream of the container apps job.
     */
    private String eventStreamEndpoint;

    /**
     * Creates an instance of JobProperties class.
     */
    public JobProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the Container Apps Job.
     * 
     * @return the provisioningState value.
     */
    public JobProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the environmentId property: Resource ID of environment.
     * 
     * @return the environmentId value.
     */
    public String environmentId() {
        return this.environmentId;
    }

    /**
     * Set the environmentId property: Resource ID of environment.
     * 
     * @param environmentId the environmentId value to set.
     * @return the JobProperties object itself.
     */
    public JobProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    /**
     * Get the workloadProfileName property: Workload profile name to pin for container apps job execution.
     * 
     * @return the workloadProfileName value.
     */
    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    /**
     * Set the workloadProfileName property: Workload profile name to pin for container apps job execution.
     * 
     * @param workloadProfileName the workloadProfileName value to set.
     * @return the JobProperties object itself.
     */
    public JobProperties withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    /**
     * Get the configuration property: Container Apps Job configuration properties.
     * 
     * @return the configuration value.
     */
    public JobConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Container Apps Job configuration properties.
     * 
     * @param configuration the configuration value to set.
     * @return the JobProperties object itself.
     */
    public JobProperties withConfiguration(JobConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the template property: Container Apps job definition.
     * 
     * @return the template value.
     */
    public JobTemplate template() {
        return this.template;
    }

    /**
     * Set the template property: Container Apps job definition.
     * 
     * @param template the template value to set.
     * @return the JobProperties object itself.
     */
    public JobProperties withTemplate(JobTemplate template) {
        this.template = template;
        return this;
    }

    /**
     * Get the outboundIpAddresses property: Outbound IP Addresses of a container apps job.
     * 
     * @return the outboundIpAddresses value.
     */
    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    /**
     * Get the eventStreamEndpoint property: The endpoint of the eventstream of the container apps job.
     * 
     * @return the eventStreamEndpoint value.
     */
    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
        if (template() != null) {
            template().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeStringField("workloadProfileName", this.workloadProfileName);
        jsonWriter.writeJsonField("configuration", this.configuration);
        jsonWriter.writeJsonField("template", this.template);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the JobProperties.
     */
    public static JobProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobProperties deserializedJobProperties = new JobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedJobProperties.provisioningState = JobProvisioningState.fromString(reader.getString());
                } else if ("environmentId".equals(fieldName)) {
                    deserializedJobProperties.environmentId = reader.getString();
                } else if ("workloadProfileName".equals(fieldName)) {
                    deserializedJobProperties.workloadProfileName = reader.getString();
                } else if ("configuration".equals(fieldName)) {
                    deserializedJobProperties.configuration = JobConfiguration.fromJson(reader);
                } else if ("template".equals(fieldName)) {
                    deserializedJobProperties.template = JobTemplate.fromJson(reader);
                } else if ("outboundIpAddresses".equals(fieldName)) {
                    List<String> outboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedJobProperties.outboundIpAddresses = outboundIpAddresses;
                } else if ("eventStreamEndpoint".equals(fieldName)) {
                    deserializedJobProperties.eventStreamEndpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobProperties;
        });
    }
}
