// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificateProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment.
 */
@Fluent
public final class ManagedCertificateInner extends Resource {
    /*
     * Certificate resource specific properties
     */
    private ManagedCertificateProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ManagedCertificateInner class.
     */
    public ManagedCertificateInner() {
    }

    /**
     * Get the properties property: Certificate resource specific properties.
     * 
     * @return the properties value.
     */
    public ManagedCertificateProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Certificate resource specific properties.
     * 
     * @param properties the properties value to set.
     * @return the ManagedCertificateInner object itself.
     */
    public ManagedCertificateInner withProperties(ManagedCertificateProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedCertificateInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedCertificateInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedCertificateInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedCertificateInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedCertificateInner.
     */
    public static ManagedCertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedCertificateInner deserializedManagedCertificateInner = new ManagedCertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedCertificateInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedCertificateInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedCertificateInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedManagedCertificateInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedCertificateInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedCertificateInner.properties = ManagedCertificateProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedManagedCertificateInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedCertificateInner;
        });
    }
}
