// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ContainerType;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.PoolManagementType;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPoolProvisioningState;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import java.io.IOException;
import java.util.List;

/**
 * Container App session pool resource specific properties.
 */
@Fluent
public final class SessionPoolProperties implements JsonSerializable<SessionPoolProperties> {
    /*
     * Resource ID of the session pool's environment.
     */
    private String environmentId;

    /*
     * The container type of the sessions.
     */
    private ContainerType containerType;

    /*
     * The pool management type of the session pool.
     */
    private PoolManagementType poolManagementType;

    /*
     * The number of nodes the session pool is using.
     */
    private Integer nodeCount;

    /*
     * The scale configuration of the session pool.
     */
    private ScaleConfiguration scaleConfiguration;

    /*
     * The secrets of the session pool.
     */
    private List<SessionPoolSecret> secrets;

    /*
     * The pool configuration if the poolManagementType is dynamic.
     */
    private DynamicPoolConfiguration dynamicPoolConfiguration;

    /*
     * The custom container configuration if the containerType is CustomContainer.
     */
    private CustomContainerTemplate customContainerTemplate;

    /*
     * The network configuration of the sessions in the session pool.
     */
    private SessionNetworkConfiguration sessionNetworkConfiguration;

    /*
     * The endpoint to manage the pool.
     */
    private String poolManagementEndpoint;

    /*
     * Provisioning state of the session pool.
     */
    private SessionPoolProvisioningState provisioningState;

    /**
     * Creates an instance of SessionPoolProperties class.
     */
    public SessionPoolProperties() {
    }

    /**
     * Get the environmentId property: Resource ID of the session pool's environment.
     * 
     * @return the environmentId value.
     */
    public String environmentId() {
        return this.environmentId;
    }

    /**
     * Set the environmentId property: Resource ID of the session pool's environment.
     * 
     * @param environmentId the environmentId value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    /**
     * Get the containerType property: The container type of the sessions.
     * 
     * @return the containerType value.
     */
    public ContainerType containerType() {
        return this.containerType;
    }

    /**
     * Set the containerType property: The container type of the sessions.
     * 
     * @param containerType the containerType value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties withContainerType(ContainerType containerType) {
        this.containerType = containerType;
        return this;
    }

    /**
     * Get the poolManagementType property: The pool management type of the session pool.
     * 
     * @return the poolManagementType value.
     */
    public PoolManagementType poolManagementType() {
        return this.poolManagementType;
    }

    /**
     * Set the poolManagementType property: The pool management type of the session pool.
     * 
     * @param poolManagementType the poolManagementType value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties withPoolManagementType(PoolManagementType poolManagementType) {
        this.poolManagementType = poolManagementType;
        return this;
    }

    /**
     * Get the nodeCount property: The number of nodes the session pool is using.
     * 
     * @return the nodeCount value.
     */
    public Integer nodeCount() {
        return this.nodeCount;
    }

    /**
     * Get the scaleConfiguration property: The scale configuration of the session pool.
     * 
     * @return the scaleConfiguration value.
     */
    public ScaleConfiguration scaleConfiguration() {
        return this.scaleConfiguration;
    }

    /**
     * Set the scaleConfiguration property: The scale configuration of the session pool.
     * 
     * @param scaleConfiguration the scaleConfiguration value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        this.scaleConfiguration = scaleConfiguration;
        return this;
    }

    /**
     * Get the secrets property: The secrets of the session pool.
     * 
     * @return the secrets value.
     */
    public List<SessionPoolSecret> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: The secrets of the session pool.
     * 
     * @param secrets the secrets value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties withSecrets(List<SessionPoolSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is dynamic.
     * 
     * @return the dynamicPoolConfiguration value.
     */
    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.dynamicPoolConfiguration;
    }

    /**
     * Set the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is dynamic.
     * 
     * @param dynamicPoolConfiguration the dynamicPoolConfiguration value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        this.dynamicPoolConfiguration = dynamicPoolConfiguration;
        return this;
    }

    /**
     * Get the customContainerTemplate property: The custom container configuration if the containerType is
     * CustomContainer.
     * 
     * @return the customContainerTemplate value.
     */
    public CustomContainerTemplate customContainerTemplate() {
        return this.customContainerTemplate;
    }

    /**
     * Set the customContainerTemplate property: The custom container configuration if the containerType is
     * CustomContainer.
     * 
     * @param customContainerTemplate the customContainerTemplate value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        this.customContainerTemplate = customContainerTemplate;
        return this;
    }

    /**
     * Get the sessionNetworkConfiguration property: The network configuration of the sessions in the session pool.
     * 
     * @return the sessionNetworkConfiguration value.
     */
    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.sessionNetworkConfiguration;
    }

    /**
     * Set the sessionNetworkConfiguration property: The network configuration of the sessions in the session pool.
     * 
     * @param sessionNetworkConfiguration the sessionNetworkConfiguration value to set.
     * @return the SessionPoolProperties object itself.
     */
    public SessionPoolProperties
        withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        this.sessionNetworkConfiguration = sessionNetworkConfiguration;
        return this;
    }

    /**
     * Get the poolManagementEndpoint property: The endpoint to manage the pool.
     * 
     * @return the poolManagementEndpoint value.
     */
    public String poolManagementEndpoint() {
        return this.poolManagementEndpoint;
    }

    /**
     * Get the provisioningState property: Provisioning state of the session pool.
     * 
     * @return the provisioningState value.
     */
    public SessionPoolProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scaleConfiguration() != null) {
            scaleConfiguration().validate();
        }
        if (secrets() != null) {
            secrets().forEach(e -> e.validate());
        }
        if (dynamicPoolConfiguration() != null) {
            dynamicPoolConfiguration().validate();
        }
        if (customContainerTemplate() != null) {
            customContainerTemplate().validate();
        }
        if (sessionNetworkConfiguration() != null) {
            sessionNetworkConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeStringField("containerType", this.containerType == null ? null : this.containerType.toString());
        jsonWriter.writeStringField("poolManagementType",
            this.poolManagementType == null ? null : this.poolManagementType.toString());
        jsonWriter.writeJsonField("scaleConfiguration", this.scaleConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("dynamicPoolConfiguration", this.dynamicPoolConfiguration);
        jsonWriter.writeJsonField("customContainerTemplate", this.customContainerTemplate);
        jsonWriter.writeJsonField("sessionNetworkConfiguration", this.sessionNetworkConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SessionPoolProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SessionPoolProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SessionPoolProperties.
     */
    public static SessionPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SessionPoolProperties deserializedSessionPoolProperties = new SessionPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("environmentId".equals(fieldName)) {
                    deserializedSessionPoolProperties.environmentId = reader.getString();
                } else if ("containerType".equals(fieldName)) {
                    deserializedSessionPoolProperties.containerType = ContainerType.fromString(reader.getString());
                } else if ("poolManagementType".equals(fieldName)) {
                    deserializedSessionPoolProperties.poolManagementType
                        = PoolManagementType.fromString(reader.getString());
                } else if ("nodeCount".equals(fieldName)) {
                    deserializedSessionPoolProperties.nodeCount = reader.getNullable(JsonReader::getInt);
                } else if ("scaleConfiguration".equals(fieldName)) {
                    deserializedSessionPoolProperties.scaleConfiguration = ScaleConfiguration.fromJson(reader);
                } else if ("secrets".equals(fieldName)) {
                    List<SessionPoolSecret> secrets = reader.readArray(reader1 -> SessionPoolSecret.fromJson(reader1));
                    deserializedSessionPoolProperties.secrets = secrets;
                } else if ("dynamicPoolConfiguration".equals(fieldName)) {
                    deserializedSessionPoolProperties.dynamicPoolConfiguration
                        = DynamicPoolConfiguration.fromJson(reader);
                } else if ("customContainerTemplate".equals(fieldName)) {
                    deserializedSessionPoolProperties.customContainerTemplate
                        = CustomContainerTemplate.fromJson(reader);
                } else if ("sessionNetworkConfiguration".equals(fieldName)) {
                    deserializedSessionPoolProperties.sessionNetworkConfiguration
                        = SessionNetworkConfiguration.fromJson(reader);
                } else if ("poolManagementEndpoint".equals(fieldName)) {
                    deserializedSessionPoolProperties.poolManagementEndpoint = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedSessionPoolProperties.provisioningState
                        = SessionPoolProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSessionPoolProperties;
        });
    }
}
