// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import java.io.IOException;
import java.util.List;

/**
 * Session pool resource specific updatable properties.
 */
@Fluent
public final class SessionPoolUpdatablePropertiesProperties
    implements JsonSerializable<SessionPoolUpdatablePropertiesProperties> {
    /*
     * The scale configuration of the session pool.
     */
    private ScaleConfiguration scaleConfiguration;

    /*
     * The secrets of the session pool.
     */
    private List<SessionPoolSecret> secrets;

    /*
     * The pool configuration if the poolManagementType is dynamic.
     */
    private DynamicPoolConfiguration dynamicPoolConfiguration;

    /*
     * The custom container configuration if the containerType is CustomContainer.
     */
    private CustomContainerTemplate customContainerTemplate;

    /*
     * The network configuration of the sessions in the session pool.
     */
    private SessionNetworkConfiguration sessionNetworkConfiguration;

    /**
     * Creates an instance of SessionPoolUpdatablePropertiesProperties class.
     */
    public SessionPoolUpdatablePropertiesProperties() {
    }

    /**
     * Get the scaleConfiguration property: The scale configuration of the session pool.
     * 
     * @return the scaleConfiguration value.
     */
    public ScaleConfiguration scaleConfiguration() {
        return this.scaleConfiguration;
    }

    /**
     * Set the scaleConfiguration property: The scale configuration of the session pool.
     * 
     * @param scaleConfiguration the scaleConfiguration value to set.
     * @return the SessionPoolUpdatablePropertiesProperties object itself.
     */
    public SessionPoolUpdatablePropertiesProperties withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        this.scaleConfiguration = scaleConfiguration;
        return this;
    }

    /**
     * Get the secrets property: The secrets of the session pool.
     * 
     * @return the secrets value.
     */
    public List<SessionPoolSecret> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: The secrets of the session pool.
     * 
     * @param secrets the secrets value to set.
     * @return the SessionPoolUpdatablePropertiesProperties object itself.
     */
    public SessionPoolUpdatablePropertiesProperties withSecrets(List<SessionPoolSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is dynamic.
     * 
     * @return the dynamicPoolConfiguration value.
     */
    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.dynamicPoolConfiguration;
    }

    /**
     * Set the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is dynamic.
     * 
     * @param dynamicPoolConfiguration the dynamicPoolConfiguration value to set.
     * @return the SessionPoolUpdatablePropertiesProperties object itself.
     */
    public SessionPoolUpdatablePropertiesProperties
        withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        this.dynamicPoolConfiguration = dynamicPoolConfiguration;
        return this;
    }

    /**
     * Get the customContainerTemplate property: The custom container configuration if the containerType is
     * CustomContainer.
     * 
     * @return the customContainerTemplate value.
     */
    public CustomContainerTemplate customContainerTemplate() {
        return this.customContainerTemplate;
    }

    /**
     * Set the customContainerTemplate property: The custom container configuration if the containerType is
     * CustomContainer.
     * 
     * @param customContainerTemplate the customContainerTemplate value to set.
     * @return the SessionPoolUpdatablePropertiesProperties object itself.
     */
    public SessionPoolUpdatablePropertiesProperties
        withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        this.customContainerTemplate = customContainerTemplate;
        return this;
    }

    /**
     * Get the sessionNetworkConfiguration property: The network configuration of the sessions in the session pool.
     * 
     * @return the sessionNetworkConfiguration value.
     */
    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.sessionNetworkConfiguration;
    }

    /**
     * Set the sessionNetworkConfiguration property: The network configuration of the sessions in the session pool.
     * 
     * @param sessionNetworkConfiguration the sessionNetworkConfiguration value to set.
     * @return the SessionPoolUpdatablePropertiesProperties object itself.
     */
    public SessionPoolUpdatablePropertiesProperties
        withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        this.sessionNetworkConfiguration = sessionNetworkConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scaleConfiguration() != null) {
            scaleConfiguration().validate();
        }
        if (secrets() != null) {
            secrets().forEach(e -> e.validate());
        }
        if (dynamicPoolConfiguration() != null) {
            dynamicPoolConfiguration().validate();
        }
        if (customContainerTemplate() != null) {
            customContainerTemplate().validate();
        }
        if (sessionNetworkConfiguration() != null) {
            sessionNetworkConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scaleConfiguration", this.scaleConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("dynamicPoolConfiguration", this.dynamicPoolConfiguration);
        jsonWriter.writeJsonField("customContainerTemplate", this.customContainerTemplate);
        jsonWriter.writeJsonField("sessionNetworkConfiguration", this.sessionNetworkConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SessionPoolUpdatablePropertiesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SessionPoolUpdatablePropertiesProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SessionPoolUpdatablePropertiesProperties.
     */
    public static SessionPoolUpdatablePropertiesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SessionPoolUpdatablePropertiesProperties deserializedSessionPoolUpdatablePropertiesProperties
                = new SessionPoolUpdatablePropertiesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scaleConfiguration".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.scaleConfiguration
                        = ScaleConfiguration.fromJson(reader);
                } else if ("secrets".equals(fieldName)) {
                    List<SessionPoolSecret> secrets = reader.readArray(reader1 -> SessionPoolSecret.fromJson(reader1));
                    deserializedSessionPoolUpdatablePropertiesProperties.secrets = secrets;
                } else if ("dynamicPoolConfiguration".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.dynamicPoolConfiguration
                        = DynamicPoolConfiguration.fromJson(reader);
                } else if ("customContainerTemplate".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.customContainerTemplate
                        = CustomContainerTemplate.fromJson(reader);
                } else if ("sessionNetworkConfiguration".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.sessionNetworkConfiguration
                        = SessionNetworkConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSessionPoolUpdatablePropertiesProperties;
        });
    }
}
