// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.GithubActionConfiguration;
import com.azure.resourcemanager.appcontainers.models.SourceControlOperationState;
import java.io.IOException;

/**
 * Container App SourceControl.
 */
@Fluent
public final class SourceControlInner extends ProxyResource {
    /*
     * SourceControl resource specific properties
     */
    private SourceControlProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of SourceControlInner class.
     */
    public SourceControlInner() {
    }

    /**
     * Get the innerProperties property: SourceControl resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SourceControlProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the operationState property: Current provisioning State of the operation.
     * 
     * @return the operationState value.
     */
    public SourceControlOperationState operationState() {
        return this.innerProperties() == null ? null : this.innerProperties().operationState();
    }

    /**
     * Get the repoUrl property: The repo url which will be integrated to ContainerApp.
     * 
     * @return the repoUrl value.
     */
    public String repoUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repoUrl();
    }

    /**
     * Set the repoUrl property: The repo url which will be integrated to ContainerApp.
     * 
     * @param repoUrl the repoUrl value to set.
     * @return the SourceControlInner object itself.
     */
    public SourceControlInner withRepoUrl(String repoUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withRepoUrl(repoUrl);
        return this;
    }

    /**
     * Get the branch property: The branch which will trigger the auto deployment.
     * 
     * @return the branch value.
     */
    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    /**
     * Set the branch property: The branch which will trigger the auto deployment.
     * 
     * @param branch the branch value to set.
     * @return the SourceControlInner object itself.
     */
    public SourceControlInner withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    /**
     * Get the githubActionConfiguration property: Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time.
     * 
     * @return the githubActionConfiguration value.
     */
    public GithubActionConfiguration githubActionConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().githubActionConfiguration();
    }

    /**
     * Set the githubActionConfiguration property: Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time.
     * 
     * @param githubActionConfiguration the githubActionConfiguration value to set.
     * @return the SourceControlInner object itself.
     */
    public SourceControlInner withGithubActionConfiguration(GithubActionConfiguration githubActionConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withGithubActionConfiguration(githubActionConfiguration);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceControlInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceControlInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SourceControlInner.
     */
    public static SourceControlInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceControlInner deserializedSourceControlInner = new SourceControlInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSourceControlInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSourceControlInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSourceControlInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSourceControlInner.innerProperties = SourceControlProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedSourceControlInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceControlInner;
        });
    }
}
