// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.UsageName;
import java.io.IOException;

/**
 * Describes Compute Resource Usage.
 */
@Fluent
public final class UsageInner implements JsonSerializable<UsageInner> {
    /*
     * An enum describing the unit of usage measurement.
     */
    private String unit = "Count";

    /*
     * The current usage of the resource.
     */
    private float currentValue;

    /*
     * The maximum permitted usage of the resource.
     */
    private float limit;

    /*
     * The name of the type of usage.
     */
    private UsageName name;

    /**
     * Creates an instance of UsageInner class.
     */
    public UsageInner() {
    }

    /**
     * Get the unit property: An enum describing the unit of usage measurement.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set the unit property: An enum describing the unit of usage measurement.
     * 
     * @param unit the unit value to set.
     * @return the UsageInner object itself.
     */
    public UsageInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the currentValue property: The current usage of the resource.
     * 
     * @return the currentValue value.
     */
    public float currentValue() {
        return this.currentValue;
    }

    /**
     * Set the currentValue property: The current usage of the resource.
     * 
     * @param currentValue the currentValue value to set.
     * @return the UsageInner object itself.
     */
    public UsageInner withCurrentValue(float currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    /**
     * Get the limit property: The maximum permitted usage of the resource.
     * 
     * @return the limit value.
     */
    public float limit() {
        return this.limit;
    }

    /**
     * Set the limit property: The maximum permitted usage of the resource.
     * 
     * @param limit the limit value to set.
     * @return the UsageInner object itself.
     */
    public UsageInner withLimit(float limit) {
        this.limit = limit;
        return this;
    }

    /**
     * Get the name property: The name of the type of usage.
     * 
     * @return the name value.
     */
    public UsageName name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the type of usage.
     * 
     * @param name the name value to set.
     * @return the UsageInner object itself.
     */
    public UsageInner withName(UsageName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model UsageInner"));
        } else {
            name().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UsageInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeFloatField("currentValue", this.currentValue);
        jsonWriter.writeFloatField("limit", this.limit);
        jsonWriter.writeJsonField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UsageInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UsageInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UsageInner.
     */
    public static UsageInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UsageInner deserializedUsageInner = new UsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("currentValue".equals(fieldName)) {
                    deserializedUsageInner.currentValue = reader.getFloat();
                } else if ("limit".equals(fieldName)) {
                    deserializedUsageInner.limit = reader.getFloat();
                } else if ("name".equals(fieldName)) {
                    deserializedUsageInner.name = UsageName.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUsageInner;
        });
    }
}
