// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.WorkflowEnvelopeProperties;
import java.io.IOException;

/**
 * Workflow properties definition.
 */
@Fluent
public final class WorkflowEnvelopeInner implements JsonSerializable<WorkflowEnvelopeInner> {
    /*
     * The resource id.
     */
    private String id;

    /*
     * Gets the resource name.
     */
    private String name;

    /*
     * Gets the resource type.
     */
    private String type;

    /*
     * The resource kind.
     */
    private String kind;

    /*
     * The resource location.
     */
    private String location;

    /*
     * Additional workflow properties.
     */
    private WorkflowEnvelopeProperties properties;

    /**
     * Creates an instance of WorkflowEnvelopeInner class.
     */
    public WorkflowEnvelopeInner() {
    }

    /**
     * Get the id property: The resource id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Gets the resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Gets the resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the kind property: The resource kind.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The resource kind.
     * 
     * @param kind the kind value to set.
     * @return the WorkflowEnvelopeInner object itself.
     */
    public WorkflowEnvelopeInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the location property: The resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The resource location.
     * 
     * @param location the location value to set.
     * @return the WorkflowEnvelopeInner object itself.
     */
    public WorkflowEnvelopeInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the properties property: Additional workflow properties.
     * 
     * @return the properties value.
     */
    public WorkflowEnvelopeProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Additional workflow properties.
     * 
     * @param properties the properties value to set.
     * @return the WorkflowEnvelopeInner object itself.
     */
    public WorkflowEnvelopeInner withProperties(WorkflowEnvelopeProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowEnvelopeInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowEnvelopeInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowEnvelopeInner.
     */
    public static WorkflowEnvelopeInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowEnvelopeInner deserializedWorkflowEnvelopeInner = new WorkflowEnvelopeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.kind = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.location = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.properties = WorkflowEnvelopeProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowEnvelopeInner;
        });
    }
}
