// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appcontainers.fluent.AppResilienciesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;
import com.azure.resourcemanager.appcontainers.models.AppResiliencyCollection;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AppResilienciesClient.
 */
public final class AppResilienciesClientImpl implements AppResilienciesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AppResilienciesService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerAppsApiClientImpl client;

    /**
     * Initializes an instance of AppResilienciesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    AppResilienciesClientImpl(ContainerAppsApiClientImpl client) {
        this.service
            = RestProxy.create(AppResilienciesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerAppsApiClientAppResiliencies to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerAppsApiClie")
    public interface AppResilienciesService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{appName}/resiliencyPolicies/{name}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AppResiliencyInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("appName") String appName,
            @PathParam("name") String name, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AppResiliencyInner resiliencyEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{appName}/resiliencyPolicies/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AppResiliencyInner>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("appName") String appName,
            @PathParam("name") String name, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AppResiliencyInner resiliencyEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{appName}/resiliencyPolicies/{name}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("appName") String appName,
            @PathParam("name") String name, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{appName}/resiliencyPolicies/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AppResiliencyInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("appName") String appName,
            @PathParam("name") String name, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{appName}/resiliencyPolicies")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AppResiliencyCollection>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("appName") String appName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AppResiliencyCollection>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Create or update an application's resiliency policy.
     * 
     * Create or update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AppResiliencyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String appName,
        String name, AppResiliencyInner resiliencyEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (resiliencyEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resiliencyEnvelope is required and cannot be null."));
        } else {
            resiliencyEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, appName, name, this.client.getApiVersion(), resiliencyEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an application's resiliency policy.
     * 
     * Create or update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AppResiliencyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String appName,
        String name, AppResiliencyInner resiliencyEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (resiliencyEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resiliencyEnvelope is required and cannot be null."));
        } else {
            resiliencyEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            appName, name, this.client.getApiVersion(), resiliencyEnvelope, accept, context);
    }

    /**
     * Create or update an application's resiliency policy.
     * 
     * Create or update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AppResiliencyInner> createOrUpdateAsync(String resourceGroupName, String appName, String name,
        AppResiliencyInner resiliencyEnvelope) {
        return createOrUpdateWithResponseAsync(resourceGroupName, appName, name, resiliencyEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update an application's resiliency policy.
     * 
     * Create or update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AppResiliencyInner> createOrUpdateWithResponse(String resourceGroupName, String appName,
        String name, AppResiliencyInner resiliencyEnvelope, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, appName, name, resiliencyEnvelope, context).block();
    }

    /**
     * Create or update an application's resiliency policy.
     * 
     * Create or update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AppResiliencyInner createOrUpdate(String resourceGroupName, String appName, String name,
        AppResiliencyInner resiliencyEnvelope) {
        return createOrUpdateWithResponse(resourceGroupName, appName, name, resiliencyEnvelope, Context.NONE)
            .getValue();
    }

    /**
     * Update an application's resiliency policy.
     * 
     * Update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AppResiliencyInner>> updateWithResponseAsync(String resourceGroupName, String appName,
        String name, AppResiliencyInner resiliencyEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (resiliencyEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resiliencyEnvelope is required and cannot be null."));
        } else {
            resiliencyEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, appName, name, this.client.getApiVersion(), resiliencyEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update an application's resiliency policy.
     * 
     * Update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AppResiliencyInner>> updateWithResponseAsync(String resourceGroupName, String appName,
        String name, AppResiliencyInner resiliencyEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (resiliencyEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resiliencyEnvelope is required and cannot be null."));
        } else {
            resiliencyEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, appName,
            name, this.client.getApiVersion(), resiliencyEnvelope, accept, context);
    }

    /**
     * Update an application's resiliency policy.
     * 
     * Update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AppResiliencyInner> updateAsync(String resourceGroupName, String appName, String name,
        AppResiliencyInner resiliencyEnvelope) {
        return updateWithResponseAsync(resourceGroupName, appName, name, resiliencyEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update an application's resiliency policy.
     * 
     * Update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AppResiliencyInner> updateWithResponse(String resourceGroupName, String appName, String name,
        AppResiliencyInner resiliencyEnvelope, Context context) {
        return updateWithResponseAsync(resourceGroupName, appName, name, resiliencyEnvelope, context).block();
    }

    /**
     * Update an application's resiliency policy.
     * 
     * Update container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resiliencyEnvelope The resiliency policy to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration to setup App Resiliency.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AppResiliencyInner update(String resourceGroupName, String appName, String name,
        AppResiliencyInner resiliencyEnvelope) {
        return updateWithResponse(resourceGroupName, appName, name, resiliencyEnvelope, Context.NONE).getValue();
    }

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String appName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, appName, name, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String appName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, appName,
            name, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String appName, String name) {
        return deleteWithResponseAsync(resourceGroupName, appName, name).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String appName, String name, Context context) {
        return deleteWithResponseAsync(resourceGroupName, appName, name, context).block();
    }

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String appName, String name) {
        deleteWithResponse(resourceGroupName, appName, name, Context.NONE);
    }

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AppResiliencyInner>> getWithResponseAsync(String resourceGroupName, String appName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, appName, name, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AppResiliencyInner>> getWithResponseAsync(String resourceGroupName, String appName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, appName, name,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AppResiliencyInner> getAsync(String resourceGroupName, String appName, String name) {
        return getWithResponseAsync(resourceGroupName, appName, name).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AppResiliencyInner> getWithResponse(String resourceGroupName, String appName, String name,
        Context context) {
        return getWithResponseAsync(resourceGroupName, appName, name, context).block();
    }

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AppResiliencyInner get(String resourceGroupName, String appName, String name) {
        return getWithResponse(resourceGroupName, appName, name, Context.NONE).getValue();
    }

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AppResiliencyInner>> listSinglePageAsync(String resourceGroupName, String appName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, appName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<AppResiliencyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AppResiliencyInner>> listSinglePageAsync(String resourceGroupName, String appName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, appName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AppResiliencyInner> listAsync(String resourceGroupName, String appName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, appName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AppResiliencyInner> listAsync(String resourceGroupName, String appName, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, appName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AppResiliencyInner> list(String resourceGroupName, String appName) {
        return new PagedIterable<>(listAsync(resourceGroupName, appName));
    }

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AppResiliencyInner> list(String resourceGroupName, String appName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, appName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AppResiliencyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AppResiliencyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AppResiliencyInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
