// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.AppResilienciesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;
import com.azure.resourcemanager.appcontainers.models.AppResiliencies;
import com.azure.resourcemanager.appcontainers.models.AppResiliency;

public final class AppResilienciesImpl implements AppResiliencies {
    private static final ClientLogger LOGGER = new ClientLogger(AppResilienciesImpl.class);

    private final AppResilienciesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public AppResilienciesImpl(AppResilienciesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String appName, String name, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, appName, name, context);
    }

    public void delete(String resourceGroupName, String appName, String name) {
        this.serviceClient().delete(resourceGroupName, appName, name);
    }

    public Response<AppResiliency> getWithResponse(String resourceGroupName, String appName, String name,
        Context context) {
        Response<AppResiliencyInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, appName, name, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new AppResiliencyImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AppResiliency get(String resourceGroupName, String appName, String name) {
        AppResiliencyInner inner = this.serviceClient().get(resourceGroupName, appName, name);
        if (inner != null) {
            return new AppResiliencyImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<AppResiliency> list(String resourceGroupName, String appName) {
        PagedIterable<AppResiliencyInner> inner = this.serviceClient().list(resourceGroupName, appName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AppResiliencyImpl(inner1, this.manager()));
    }

    public PagedIterable<AppResiliency> list(String resourceGroupName, String appName, Context context) {
        PagedIterable<AppResiliencyInner> inner = this.serviceClient().list(resourceGroupName, appName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AppResiliencyImpl(inner1, this.manager()));
    }

    public AppResiliency getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, appName, name, Context.NONE).getValue();
    }

    public Response<AppResiliency> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, appName, name, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, appName, name, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, appName, name, context);
    }

    private AppResilienciesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public AppResiliencyImpl define(String name) {
        return new AppResiliencyImpl(name, this.manager());
    }
}
