// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;
import com.azure.resourcemanager.appcontainers.models.AppResiliency;
import com.azure.resourcemanager.appcontainers.models.CircuitBreakerPolicy;
import com.azure.resourcemanager.appcontainers.models.HttpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.HttpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TcpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.TcpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TimeoutPolicy;

public final class AppResiliencyImpl implements AppResiliency, AppResiliency.Definition, AppResiliency.Update {
    private AppResiliencyInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public TimeoutPolicy timeoutPolicy() {
        return this.innerModel().timeoutPolicy();
    }

    public HttpRetryPolicy httpRetryPolicy() {
        return this.innerModel().httpRetryPolicy();
    }

    public TcpRetryPolicy tcpRetryPolicy() {
        return this.innerModel().tcpRetryPolicy();
    }

    public CircuitBreakerPolicy circuitBreakerPolicy() {
        return this.innerModel().circuitBreakerPolicy();
    }

    public HttpConnectionPool httpConnectionPool() {
        return this.innerModel().httpConnectionPool();
    }

    public TcpConnectionPool tcpConnectionPool() {
        return this.innerModel().tcpConnectionPool();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public AppResiliencyInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String appName;

    private String name;

    public AppResiliencyImpl withExistingContainerApp(String resourceGroupName, String appName) {
        this.resourceGroupName = resourceGroupName;
        this.appName = appName;
        return this;
    }

    public AppResiliency create() {
        this.innerObject = serviceManager.serviceClient()
            .getAppResiliencies()
            .createOrUpdateWithResponse(resourceGroupName, appName, name, this.innerModel(), Context.NONE)
            .getValue();
        return this;
    }

    public AppResiliency create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAppResiliencies()
            .createOrUpdateWithResponse(resourceGroupName, appName, name, this.innerModel(), context)
            .getValue();
        return this;
    }

    AppResiliencyImpl(String name, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new AppResiliencyInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    public AppResiliencyImpl update() {
        return this;
    }

    public AppResiliency apply() {
        this.innerObject = serviceManager.serviceClient()
            .getAppResiliencies()
            .updateWithResponse(resourceGroupName, appName, name, this.innerModel(), Context.NONE)
            .getValue();
        return this;
    }

    public AppResiliency apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAppResiliencies()
            .updateWithResponse(resourceGroupName, appName, name, this.innerModel(), context)
            .getValue();
        return this;
    }

    AppResiliencyImpl(AppResiliencyInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.appName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "containerApps");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resiliencyPolicies");
    }

    public AppResiliency refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getAppResiliencies()
            .getWithResponse(resourceGroupName, appName, name, Context.NONE)
            .getValue();
        return this;
    }

    public AppResiliency refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAppResiliencies()
            .getWithResponse(resourceGroupName, appName, name, context)
            .getValue();
        return this;
    }

    public AppResiliencyImpl withTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.innerModel().withTimeoutPolicy(timeoutPolicy);
        return this;
    }

    public AppResiliencyImpl withHttpRetryPolicy(HttpRetryPolicy httpRetryPolicy) {
        this.innerModel().withHttpRetryPolicy(httpRetryPolicy);
        return this;
    }

    public AppResiliencyImpl withTcpRetryPolicy(TcpRetryPolicy tcpRetryPolicy) {
        this.innerModel().withTcpRetryPolicy(tcpRetryPolicy);
        return this;
    }

    public AppResiliencyImpl withCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy) {
        this.innerModel().withCircuitBreakerPolicy(circuitBreakerPolicy);
        return this;
    }

    public AppResiliencyImpl withHttpConnectionPool(HttpConnectionPool httpConnectionPool) {
        this.innerModel().withHttpConnectionPool(httpConnectionPool);
        return this;
    }

    public AppResiliencyImpl withTcpConnectionPool(TcpConnectionPool tcpConnectionPool) {
        this.innerModel().withTcpConnectionPool(tcpConnectionPool);
        return this;
    }
}
