// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.AvailableWorkloadProfilesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.AvailableWorkloadProfileInner;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfile;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfiles;

public final class AvailableWorkloadProfilesImpl implements AvailableWorkloadProfiles {
    private static final ClientLogger LOGGER = new ClientLogger(AvailableWorkloadProfilesImpl.class);

    private final AvailableWorkloadProfilesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public AvailableWorkloadProfilesImpl(AvailableWorkloadProfilesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<AvailableWorkloadProfile> get(String location) {
        PagedIterable<AvailableWorkloadProfileInner> inner = this.serviceClient().get(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvailableWorkloadProfileImpl(inner1, this.manager()));
    }

    public PagedIterable<AvailableWorkloadProfile> get(String location, Context context) {
        PagedIterable<AvailableWorkloadProfileInner> inner = this.serviceClient().get(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvailableWorkloadProfileImpl(inner1, this.manager()));
    }

    private AvailableWorkloadProfilesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
