// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.BillingMetersClient;
import com.azure.resourcemanager.appcontainers.fluent.models.BillingMeterCollectionInner;
import com.azure.resourcemanager.appcontainers.models.BillingMeterCollection;
import com.azure.resourcemanager.appcontainers.models.BillingMeters;

public final class BillingMetersImpl implements BillingMeters {
    private static final ClientLogger LOGGER = new ClientLogger(BillingMetersImpl.class);

    private final BillingMetersClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public BillingMetersImpl(BillingMetersClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<BillingMeterCollection> getWithResponse(String location, Context context) {
        Response<BillingMeterCollectionInner> inner = this.serviceClient().getWithResponse(location, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new BillingMeterCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public BillingMeterCollection get(String location) {
        BillingMeterCollectionInner inner = this.serviceClient().get(location);
        if (inner != null) {
            return new BillingMeterCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private BillingMetersClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
