// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.BuildAuthTokensClient;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildTokenInner;
import com.azure.resourcemanager.appcontainers.models.BuildAuthTokens;
import com.azure.resourcemanager.appcontainers.models.BuildToken;

public final class BuildAuthTokensImpl implements BuildAuthTokens {
    private static final ClientLogger LOGGER = new ClientLogger(BuildAuthTokensImpl.class);

    private final BuildAuthTokensClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public BuildAuthTokensImpl(BuildAuthTokensClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<BuildToken> listWithResponse(String resourceGroupName, String builderName, String buildName,
        Context context) {
        Response<BuildTokenInner> inner
            = this.serviceClient().listWithResponse(resourceGroupName, builderName, buildName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new BuildTokenImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public BuildToken list(String resourceGroupName, String builderName, String buildName) {
        BuildTokenInner inner = this.serviceClient().list(resourceGroupName, builderName, buildName);
        if (inner != null) {
            return new BuildTokenImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private BuildAuthTokensClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
