// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceInner;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuilderResource;
import com.azure.resourcemanager.appcontainers.models.BuilderResourceUpdate;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BuilderResourceImpl implements BuilderResource, BuilderResource.Definition, BuilderResource.Update {
    private BuilderResourceInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public BuilderProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String environmentId() {
        return this.innerModel().environmentId();
    }

    public List<ContainerRegistry> containerRegistries() {
        List<ContainerRegistry> inner = this.innerModel().containerRegistries();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public BuilderResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String builderName;

    private BuilderResourceUpdate updateBuilderEnvelope;

    public BuilderResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public BuilderResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getBuilders()
            .createOrUpdate(resourceGroupName, builderName, this.innerModel(), Context.NONE);
        return this;
    }

    public BuilderResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getBuilders()
            .createOrUpdate(resourceGroupName, builderName, this.innerModel(), context);
        return this;
    }

    BuilderResourceImpl(String name, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new BuilderResourceInner();
        this.serviceManager = serviceManager;
        this.builderName = name;
    }

    public BuilderResourceImpl update() {
        this.updateBuilderEnvelope = new BuilderResourceUpdate();
        return this;
    }

    public BuilderResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getBuilders()
            .update(resourceGroupName, builderName, updateBuilderEnvelope, Context.NONE);
        return this;
    }

    public BuilderResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getBuilders()
            .update(resourceGroupName, builderName, updateBuilderEnvelope, context);
        return this;
    }

    BuilderResourceImpl(BuilderResourceInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.builderName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "builders");
    }

    public BuilderResource refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getBuilders()
            .getByResourceGroupWithResponse(resourceGroupName, builderName, Context.NONE)
            .getValue();
        return this;
    }

    public BuilderResource refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getBuilders()
            .getByResourceGroupWithResponse(resourceGroupName, builderName, context)
            .getValue();
        return this;
    }

    public BuilderResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public BuilderResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public BuilderResourceImpl withTags(Map<String, String> tags) {
        if (isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        } else {
            this.updateBuilderEnvelope.withTags(tags);
            return this;
        }
    }

    public BuilderResourceImpl withIdentity(ManagedServiceIdentity identity) {
        if (isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        } else {
            this.updateBuilderEnvelope.withIdentity(identity);
            return this;
        }
    }

    public BuilderResourceImpl withEnvironmentId(String environmentId) {
        if (isInCreateMode()) {
            this.innerModel().withEnvironmentId(environmentId);
            return this;
        } else {
            this.updateBuilderEnvelope.withEnvironmentId(environmentId);
            return this;
        }
    }

    public BuilderResourceImpl withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.innerModel().withContainerRegistries(containerRegistries);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
