// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.BuildsByBuilderResourcesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;
import com.azure.resourcemanager.appcontainers.models.BuildResource;
import com.azure.resourcemanager.appcontainers.models.BuildsByBuilderResources;

public final class BuildsByBuilderResourcesImpl implements BuildsByBuilderResources {
    private static final ClientLogger LOGGER = new ClientLogger(BuildsByBuilderResourcesImpl.class);

    private final BuildsByBuilderResourcesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public BuildsByBuilderResourcesImpl(BuildsByBuilderResourcesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<BuildResource> list(String resourceGroupName, String builderName) {
        PagedIterable<BuildResourceInner> inner = this.serviceClient().list(resourceGroupName, builderName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BuildResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<BuildResource> list(String resourceGroupName, String builderName, Context context) {
        PagedIterable<BuildResourceInner> inner = this.serviceClient().list(resourceGroupName, builderName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BuildResourceImpl(inner1, this.manager()));
    }

    private BuildsByBuilderResourcesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
