// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.BuildsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;
import com.azure.resourcemanager.appcontainers.models.BuildResource;
import com.azure.resourcemanager.appcontainers.models.Builds;

public final class BuildsImpl implements Builds {
    private static final ClientLogger LOGGER = new ClientLogger(BuildsImpl.class);

    private final BuildsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public BuildsImpl(BuildsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<BuildResource> getWithResponse(String resourceGroupName, String builderName, String buildName,
        Context context) {
        Response<BuildResourceInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, builderName, buildName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new BuildResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public BuildResource get(String resourceGroupName, String builderName, String buildName) {
        BuildResourceInner inner = this.serviceClient().get(resourceGroupName, builderName, buildName);
        if (inner != null) {
            return new BuildResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String builderName, String buildName) {
        this.serviceClient().delete(resourceGroupName, builderName, buildName);
    }

    public void delete(String resourceGroupName, String builderName, String buildName, Context context) {
        this.serviceClient().delete(resourceGroupName, builderName, buildName, context);
    }

    public BuildResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String builderName = ResourceManagerUtils.getValueFromIdByName(id, "builders");
        if (builderName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builders'.", id)));
        }
        String buildName = ResourceManagerUtils.getValueFromIdByName(id, "builds");
        if (buildName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builds'.", id)));
        }
        return this.getWithResponse(resourceGroupName, builderName, buildName, Context.NONE).getValue();
    }

    public Response<BuildResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String builderName = ResourceManagerUtils.getValueFromIdByName(id, "builders");
        if (builderName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builders'.", id)));
        }
        String buildName = ResourceManagerUtils.getValueFromIdByName(id, "builds");
        if (buildName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builds'.", id)));
        }
        return this.getWithResponse(resourceGroupName, builderName, buildName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String builderName = ResourceManagerUtils.getValueFromIdByName(id, "builders");
        if (builderName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builders'.", id)));
        }
        String buildName = ResourceManagerUtils.getValueFromIdByName(id, "builds");
        if (buildName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builds'.", id)));
        }
        this.delete(resourceGroupName, builderName, buildName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String builderName = ResourceManagerUtils.getValueFromIdByName(id, "builders");
        if (builderName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builders'.", id)));
        }
        String buildName = ResourceManagerUtils.getValueFromIdByName(id, "builds");
        if (buildName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'builds'.", id)));
        }
        this.delete(resourceGroupName, builderName, buildName, context);
    }

    private BuildsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public BuildResourceImpl define(String name) {
        return new BuildResourceImpl(name, this.manager());
    }
}
