// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.CertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.CertificateInner;
import com.azure.resourcemanager.appcontainers.models.Certificate;
import com.azure.resourcemanager.appcontainers.models.CertificatePatch;
import com.azure.resourcemanager.appcontainers.models.Certificates;

public final class CertificatesImpl implements Certificates {
    private static final ClientLogger LOGGER = new ClientLogger(CertificatesImpl.class);

    private final CertificatesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public CertificatesImpl(CertificatesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<Certificate> list(String resourceGroupName, String environmentName) {
        PagedIterable<CertificateInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl(inner1, this.manager()));
    }

    public PagedIterable<Certificate> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<CertificateInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl(inner1, this.manager()));
    }

    public Response<Certificate> getWithResponse(String resourceGroupName, String environmentName,
        String certificateName, Context context) {
        Response<CertificateInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, environmentName, certificateName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CertificateImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Certificate get(String resourceGroupName, String environmentName, String certificateName) {
        CertificateInner inner = this.serviceClient().get(resourceGroupName, environmentName, certificateName);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Certificate> createOrUpdateWithResponse(String resourceGroupName, String environmentName,
        String certificateName, CertificateInner certificateEnvelope, Context context) {
        Response<CertificateInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, certificateName, certificateEnvelope,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CertificateImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Certificate createOrUpdate(String resourceGroupName, String environmentName, String certificateName) {
        CertificateInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, environmentName, certificateName);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String certificateName,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, certificateName, context);
    }

    public void delete(String resourceGroupName, String environmentName, String certificateName) {
        this.serviceClient().delete(resourceGroupName, environmentName, certificateName);
    }

    public Response<Certificate> updateWithResponse(String resourceGroupName, String environmentName,
        String certificateName, CertificatePatch certificateEnvelope, Context context) {
        Response<CertificateInner> inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, environmentName, certificateName, certificateEnvelope, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CertificateImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Certificate update(String resourceGroupName, String environmentName, String certificateName,
        CertificatePatch certificateEnvelope) {
        CertificateInner inner
            = this.serviceClient().update(resourceGroupName, environmentName, certificateName, certificateEnvelope);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private CertificatesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
