// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStorage;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStorageProperties;

public final class ConnectedEnvironmentStorageImpl
    implements ConnectedEnvironmentStorage, ConnectedEnvironmentStorage.Definition, ConnectedEnvironmentStorage.Update {
    private ConnectedEnvironmentStorageInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public ConnectedEnvironmentStorageProperties properties() {
        return this.innerModel().properties();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ConnectedEnvironmentStorageInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String connectedEnvironmentName;

    private String storageName;

    public ConnectedEnvironmentStorageImpl withExistingConnectedEnvironment(String resourceGroupName,
        String connectedEnvironmentName) {
        this.resourceGroupName = resourceGroupName;
        this.connectedEnvironmentName = connectedEnvironmentName;
        return this;
    }

    public ConnectedEnvironmentStorage create() {
        this.innerObject = serviceManager.serviceClient()
            .getConnectedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, storageName, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ConnectedEnvironmentStorage create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getConnectedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, storageName, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    ConnectedEnvironmentStorageImpl(String name,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new ConnectedEnvironmentStorageInner();
        this.serviceManager = serviceManager;
        this.storageName = name;
    }

    public ConnectedEnvironmentStorageImpl update() {
        return this;
    }

    public ConnectedEnvironmentStorage apply() {
        this.innerObject = serviceManager.serviceClient()
            .getConnectedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, storageName, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ConnectedEnvironmentStorage apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getConnectedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, storageName, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    ConnectedEnvironmentStorageImpl(ConnectedEnvironmentStorageInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.connectedEnvironmentName
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connectedEnvironments");
        this.storageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storages");
    }

    public ConnectedEnvironmentStorage refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getConnectedEnvironmentsStorages()
            .getWithResponse(resourceGroupName, connectedEnvironmentName, storageName, Context.NONE)
            .getValue();
        return this;
    }

    public ConnectedEnvironmentStorage refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getConnectedEnvironmentsStorages()
            .getWithResponse(resourceGroupName, connectedEnvironmentName, storageName, context)
            .getValue();
        return this;
    }

    public ConnectedEnvironmentStorageImpl withProperties(ConnectedEnvironmentStorageProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}
