// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsDaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.models.DaprComponentsCollection;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ConnectedEnvironmentsDaprComponentsClient.
 */
public final class ConnectedEnvironmentsDaprComponentsClientImpl implements ConnectedEnvironmentsDaprComponentsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ConnectedEnvironmentsDaprComponentsService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerAppsApiClientImpl client;

    /**
     * Initializes an instance of ConnectedEnvironmentsDaprComponentsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ConnectedEnvironmentsDaprComponentsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = RestProxy.create(ConnectedEnvironmentsDaprComponentsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerAppsApiClientConnectedEnvironmentsDaprComponents to be used
     * by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerAppsApiClie")
    public interface ConnectedEnvironmentsDaprComponentsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DaprComponentsCollection>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("connectedEnvironmentName") String connectedEnvironmentName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DaprComponentInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("connectedEnvironmentName") String connectedEnvironmentName,
            @PathParam("componentName") String componentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DaprComponentInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("connectedEnvironmentName") String connectedEnvironmentName,
            @PathParam("componentName") String componentName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DaprComponentInner daprComponentEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("connectedEnvironmentName") String connectedEnvironmentName,
            @PathParam("componentName") String componentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}/listSecrets")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DaprSecretsCollectionInner>> listSecrets(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("connectedEnvironmentName") String connectedEnvironmentName,
            @PathParam("componentName") String componentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DaprComponentsCollection>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get the Dapr Components for a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a connected environment along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listSinglePageAsync(String resourceGroupName,
        String connectedEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<DaprComponentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the Dapr Components for a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a connected environment along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listSinglePageAsync(String resourceGroupName,
        String connectedEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                connectedEnvironmentName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the Dapr Components for a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a connected environment as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DaprComponentInner> listAsync(String resourceGroupName, String connectedEnvironmentName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, connectedEnvironmentName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get the Dapr Components for a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a connected environment as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DaprComponentInner> listAsync(String resourceGroupName, String connectedEnvironmentName,
        Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, connectedEnvironmentName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get the Dapr Components for a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a connected environment as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DaprComponentInner> list(String resourceGroupName, String connectedEnvironmentName) {
        return new PagedIterable<>(listAsync(resourceGroupName, connectedEnvironmentName));
    }

    /**
     * Get the Dapr Components for a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a connected environment as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DaprComponentInner> list(String resourceGroupName, String connectedEnvironmentName,
        Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, connectedEnvironmentName, context));
    }

    /**
     * Get a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a dapr component along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> getWithResponseAsync(String resourceGroupName,
        String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    connectedEnvironmentName, componentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a dapr component along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> getWithResponseAsync(String resourceGroupName,
        String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            connectedEnvironmentName, componentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a dapr component on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DaprComponentInner> getAsync(String resourceGroupName, String connectedEnvironmentName,
        String componentName) {
        return getWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a dapr component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DaprComponentInner> getWithResponse(String resourceGroupName, String connectedEnvironmentName,
        String componentName, Context context) {
        return getWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, context).block();
    }

    /**
     * Get a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a dapr component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DaprComponentInner get(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return getWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE).getValue();
    }

    /**
     * Creates or updates a Dapr Component.
     * 
     * Creates or updates a Dapr Component in a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param daprComponentEnvelope Configuration details of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        if (daprComponentEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter daprComponentEnvelope is required and cannot be null."));
        } else {
            daprComponentEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(),
                daprComponentEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a Dapr Component.
     * 
     * Creates or updates a Dapr Component in a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param daprComponentEnvelope Configuration details of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        if (daprComponentEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter daprComponentEnvelope is required and cannot be null."));
        } else {
            daprComponentEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            connectedEnvironmentName, componentName, this.client.getApiVersion(), daprComponentEnvelope, accept,
            context);
    }

    /**
     * Creates or updates a Dapr Component.
     * 
     * Creates or updates a Dapr Component in a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param daprComponentEnvelope Configuration details of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DaprComponentInner> createOrUpdateAsync(String resourceGroupName, String connectedEnvironmentName,
        String componentName, DaprComponentInner daprComponentEnvelope) {
        return createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName,
            daprComponentEnvelope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a Dapr Component.
     * 
     * Creates or updates a Dapr Component in a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param daprComponentEnvelope Configuration details of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DaprComponentInner> createOrUpdateWithResponse(String resourceGroupName,
        String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope,
        Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName,
            daprComponentEnvelope, context).block();
    }

    /**
     * Creates or updates a Dapr Component.
     * 
     * Creates or updates a Dapr Component in a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param daprComponentEnvelope Configuration details of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DaprComponentInner createOrUpdate(String resourceGroupName, String connectedEnvironmentName,
        String componentName, DaprComponentInner daprComponentEnvelope) {
        return createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, componentName,
            daprComponentEnvelope, Context.NONE).getValue();
    }

    /**
     * Delete a Dapr Component.
     * 
     * Delete a Dapr Component from a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName,
        String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    connectedEnvironmentName, componentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a Dapr Component.
     * 
     * Delete a Dapr Component from a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName,
        String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            connectedEnvironmentName, componentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a Dapr Component.
     * 
     * Delete a Dapr Component from a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a Dapr Component.
     * 
     * Delete a Dapr Component from a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName,
        String componentName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, context).block();
    }

    /**
     * Delete a Dapr Component.
     * 
     * Delete a Dapr Component from a connected environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        deleteWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE);
    }

    /**
     * List secrets for a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr component Secrets Collection for ListSecrets Action along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DaprSecretsCollectionInner>> listSecretsWithResponseAsync(String resourceGroupName,
        String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSecrets(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List secrets for a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr component Secrets Collection for ListSecrets Action along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DaprSecretsCollectionInner>> listSecretsWithResponseAsync(String resourceGroupName,
        String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listSecrets(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            connectedEnvironmentName, componentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * List secrets for a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr component Secrets Collection for ListSecrets Action on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DaprSecretsCollectionInner> listSecretsAsync(String resourceGroupName, String connectedEnvironmentName,
        String componentName) {
        return listSecretsWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * List secrets for a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr component Secrets Collection for ListSecrets Action along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DaprSecretsCollectionInner> listSecretsWithResponse(String resourceGroupName,
        String connectedEnvironmentName, String componentName, Context context) {
        return listSecretsWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, context)
            .block();
    }

    /**
     * List secrets for a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr component Secrets Collection for ListSecrets Action.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DaprSecretsCollectionInner listSecrets(String resourceGroupName, String connectedEnvironmentName,
        String componentName) {
        return listSecretsWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE)
            .getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Components ARM resource along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DaprComponentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Components ARM resource along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
