// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.appcontainers.fluent.AppResilienciesClient;
import com.azure.resourcemanager.appcontainers.fluent.AvailableWorkloadProfilesClient;
import com.azure.resourcemanager.appcontainers.fluent.BillingMetersClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildAuthTokensClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildersClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildsByBuilderResourcesClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildsClient;
import com.azure.resourcemanager.appcontainers.fluent.CertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsCertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsDaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsApiClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsAuthConfigsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsBuildsByContainerAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsBuildsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsPatchesClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionReplicasClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsSessionPoolsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsSourceControlsClient;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentResiliencyPoliciesClient;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.DaprSubscriptionsClient;
import com.azure.resourcemanager.appcontainers.fluent.DotNetComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.FunctionsExtensionsClient;
import com.azure.resourcemanager.appcontainers.fluent.JavaComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.JobsClient;
import com.azure.resourcemanager.appcontainers.fluent.JobsExecutionsClient;
import com.azure.resourcemanager.appcontainers.fluent.LogicAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedCertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentPrivateEndpointConnectionsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentPrivateLinkResourcesClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentUsagesClient;
import com.azure.resourcemanager.appcontainers.fluent.NamespacesClient;
import com.azure.resourcemanager.appcontainers.fluent.OperationsClient;
import com.azure.resourcemanager.appcontainers.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.appcontainers.fluent.UsagesClient;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the ContainerAppsApiClientImpl type.
 */
@ServiceClient(builder = ContainerAppsApiClientBuilder.class)
public final class ContainerAppsApiClientImpl implements ContainerAppsApiClient {
    /**
     * The ID of the target subscription. The value must be an UUID.
     */
    private final String subscriptionId;

    /**
     * Gets The ID of the target subscription. The value must be an UUID.
     * 
     * @return the subscriptionId value.
     */
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /**
     * server parameter.
     */
    private final String endpoint;

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Api Version.
     */
    private final String apiVersion;

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * The default poll interval for long-running operation.
     */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /**
     * The AppResilienciesClient object to access its operations.
     */
    private final AppResilienciesClient appResiliencies;

    /**
     * Gets the AppResilienciesClient object to access its operations.
     * 
     * @return the AppResilienciesClient object.
     */
    public AppResilienciesClient getAppResiliencies() {
        return this.appResiliencies;
    }

    /**
     * The ContainerAppsAuthConfigsClient object to access its operations.
     */
    private final ContainerAppsAuthConfigsClient containerAppsAuthConfigs;

    /**
     * Gets the ContainerAppsAuthConfigsClient object to access its operations.
     * 
     * @return the ContainerAppsAuthConfigsClient object.
     */
    public ContainerAppsAuthConfigsClient getContainerAppsAuthConfigs() {
        return this.containerAppsAuthConfigs;
    }

    /**
     * The AvailableWorkloadProfilesClient object to access its operations.
     */
    private final AvailableWorkloadProfilesClient availableWorkloadProfiles;

    /**
     * Gets the AvailableWorkloadProfilesClient object to access its operations.
     * 
     * @return the AvailableWorkloadProfilesClient object.
     */
    public AvailableWorkloadProfilesClient getAvailableWorkloadProfiles() {
        return this.availableWorkloadProfiles;
    }

    /**
     * The BillingMetersClient object to access its operations.
     */
    private final BillingMetersClient billingMeters;

    /**
     * Gets the BillingMetersClient object to access its operations.
     * 
     * @return the BillingMetersClient object.
     */
    public BillingMetersClient getBillingMeters() {
        return this.billingMeters;
    }

    /**
     * The BuildersClient object to access its operations.
     */
    private final BuildersClient builders;

    /**
     * Gets the BuildersClient object to access its operations.
     * 
     * @return the BuildersClient object.
     */
    public BuildersClient getBuilders() {
        return this.builders;
    }

    /**
     * The BuildsByBuilderResourcesClient object to access its operations.
     */
    private final BuildsByBuilderResourcesClient buildsByBuilderResources;

    /**
     * Gets the BuildsByBuilderResourcesClient object to access its operations.
     * 
     * @return the BuildsByBuilderResourcesClient object.
     */
    public BuildsByBuilderResourcesClient getBuildsByBuilderResources() {
        return this.buildsByBuilderResources;
    }

    /**
     * The BuildsClient object to access its operations.
     */
    private final BuildsClient builds;

    /**
     * Gets the BuildsClient object to access its operations.
     * 
     * @return the BuildsClient object.
     */
    public BuildsClient getBuilds() {
        return this.builds;
    }

    /**
     * The BuildAuthTokensClient object to access its operations.
     */
    private final BuildAuthTokensClient buildAuthTokens;

    /**
     * Gets the BuildAuthTokensClient object to access its operations.
     * 
     * @return the BuildAuthTokensClient object.
     */
    public BuildAuthTokensClient getBuildAuthTokens() {
        return this.buildAuthTokens;
    }

    /**
     * The ConnectedEnvironmentsClient object to access its operations.
     */
    private final ConnectedEnvironmentsClient connectedEnvironments;

    /**
     * Gets the ConnectedEnvironmentsClient object to access its operations.
     * 
     * @return the ConnectedEnvironmentsClient object.
     */
    public ConnectedEnvironmentsClient getConnectedEnvironments() {
        return this.connectedEnvironments;
    }

    /**
     * The ConnectedEnvironmentsCertificatesClient object to access its operations.
     */
    private final ConnectedEnvironmentsCertificatesClient connectedEnvironmentsCertificates;

    /**
     * Gets the ConnectedEnvironmentsCertificatesClient object to access its operations.
     * 
     * @return the ConnectedEnvironmentsCertificatesClient object.
     */
    public ConnectedEnvironmentsCertificatesClient getConnectedEnvironmentsCertificates() {
        return this.connectedEnvironmentsCertificates;
    }

    /**
     * The ConnectedEnvironmentsDaprComponentsClient object to access its operations.
     */
    private final ConnectedEnvironmentsDaprComponentsClient connectedEnvironmentsDaprComponents;

    /**
     * Gets the ConnectedEnvironmentsDaprComponentsClient object to access its operations.
     * 
     * @return the ConnectedEnvironmentsDaprComponentsClient object.
     */
    public ConnectedEnvironmentsDaprComponentsClient getConnectedEnvironmentsDaprComponents() {
        return this.connectedEnvironmentsDaprComponents;
    }

    /**
     * The ConnectedEnvironmentsStoragesClient object to access its operations.
     */
    private final ConnectedEnvironmentsStoragesClient connectedEnvironmentsStorages;

    /**
     * Gets the ConnectedEnvironmentsStoragesClient object to access its operations.
     * 
     * @return the ConnectedEnvironmentsStoragesClient object.
     */
    public ConnectedEnvironmentsStoragesClient getConnectedEnvironmentsStorages() {
        return this.connectedEnvironmentsStorages;
    }

    /**
     * The ContainerAppsClient object to access its operations.
     */
    private final ContainerAppsClient containerApps;

    /**
     * Gets the ContainerAppsClient object to access its operations.
     * 
     * @return the ContainerAppsClient object.
     */
    public ContainerAppsClient getContainerApps() {
        return this.containerApps;
    }

    /**
     * The ContainerAppsRevisionsClient object to access its operations.
     */
    private final ContainerAppsRevisionsClient containerAppsRevisions;

    /**
     * Gets the ContainerAppsRevisionsClient object to access its operations.
     * 
     * @return the ContainerAppsRevisionsClient object.
     */
    public ContainerAppsRevisionsClient getContainerAppsRevisions() {
        return this.containerAppsRevisions;
    }

    /**
     * The ContainerAppsRevisionReplicasClient object to access its operations.
     */
    private final ContainerAppsRevisionReplicasClient containerAppsRevisionReplicas;

    /**
     * Gets the ContainerAppsRevisionReplicasClient object to access its operations.
     * 
     * @return the ContainerAppsRevisionReplicasClient object.
     */
    public ContainerAppsRevisionReplicasClient getContainerAppsRevisionReplicas() {
        return this.containerAppsRevisionReplicas;
    }

    /**
     * The ContainerAppsBuildsByContainerAppsClient object to access its operations.
     */
    private final ContainerAppsBuildsByContainerAppsClient containerAppsBuildsByContainerApps;

    /**
     * Gets the ContainerAppsBuildsByContainerAppsClient object to access its operations.
     * 
     * @return the ContainerAppsBuildsByContainerAppsClient object.
     */
    public ContainerAppsBuildsByContainerAppsClient getContainerAppsBuildsByContainerApps() {
        return this.containerAppsBuildsByContainerApps;
    }

    /**
     * The ContainerAppsBuildsClient object to access its operations.
     */
    private final ContainerAppsBuildsClient containerAppsBuilds;

    /**
     * Gets the ContainerAppsBuildsClient object to access its operations.
     * 
     * @return the ContainerAppsBuildsClient object.
     */
    public ContainerAppsBuildsClient getContainerAppsBuilds() {
        return this.containerAppsBuilds;
    }

    /**
     * The ContainerAppsPatchesClient object to access its operations.
     */
    private final ContainerAppsPatchesClient containerAppsPatches;

    /**
     * Gets the ContainerAppsPatchesClient object to access its operations.
     * 
     * @return the ContainerAppsPatchesClient object.
     */
    public ContainerAppsPatchesClient getContainerAppsPatches() {
        return this.containerAppsPatches;
    }

    /**
     * The ContainerAppsDiagnosticsClient object to access its operations.
     */
    private final ContainerAppsDiagnosticsClient containerAppsDiagnostics;

    /**
     * Gets the ContainerAppsDiagnosticsClient object to access its operations.
     * 
     * @return the ContainerAppsDiagnosticsClient object.
     */
    public ContainerAppsDiagnosticsClient getContainerAppsDiagnostics() {
        return this.containerAppsDiagnostics;
    }

    /**
     * The ManagedEnvironmentDiagnosticsClient object to access its operations.
     */
    private final ManagedEnvironmentDiagnosticsClient managedEnvironmentDiagnostics;

    /**
     * Gets the ManagedEnvironmentDiagnosticsClient object to access its operations.
     * 
     * @return the ManagedEnvironmentDiagnosticsClient object.
     */
    public ManagedEnvironmentDiagnosticsClient getManagedEnvironmentDiagnostics() {
        return this.managedEnvironmentDiagnostics;
    }

    /**
     * The ManagedEnvironmentsDiagnosticsClient object to access its operations.
     */
    private final ManagedEnvironmentsDiagnosticsClient managedEnvironmentsDiagnostics;

    /**
     * Gets the ManagedEnvironmentsDiagnosticsClient object to access its operations.
     * 
     * @return the ManagedEnvironmentsDiagnosticsClient object.
     */
    public ManagedEnvironmentsDiagnosticsClient getManagedEnvironmentsDiagnostics() {
        return this.managedEnvironmentsDiagnostics;
    }

    /**
     * The JobsClient object to access its operations.
     */
    private final JobsClient jobs;

    /**
     * Gets the JobsClient object to access its operations.
     * 
     * @return the JobsClient object.
     */
    public JobsClient getJobs() {
        return this.jobs;
    }

    /**
     * The DotNetComponentsClient object to access its operations.
     */
    private final DotNetComponentsClient dotNetComponents;

    /**
     * Gets the DotNetComponentsClient object to access its operations.
     * 
     * @return the DotNetComponentsClient object.
     */
    public DotNetComponentsClient getDotNetComponents() {
        return this.dotNetComponents;
    }

    /**
     * The OperationsClient object to access its operations.
     */
    private final OperationsClient operations;

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    public OperationsClient getOperations() {
        return this.operations;
    }

    /**
     * The JavaComponentsClient object to access its operations.
     */
    private final JavaComponentsClient javaComponents;

    /**
     * Gets the JavaComponentsClient object to access its operations.
     * 
     * @return the JavaComponentsClient object.
     */
    public JavaComponentsClient getJavaComponents() {
        return this.javaComponents;
    }

    /**
     * The JobsExecutionsClient object to access its operations.
     */
    private final JobsExecutionsClient jobsExecutions;

    /**
     * Gets the JobsExecutionsClient object to access its operations.
     * 
     * @return the JobsExecutionsClient object.
     */
    public JobsExecutionsClient getJobsExecutions() {
        return this.jobsExecutions;
    }

    /**
     * The ResourceProvidersClient object to access its operations.
     */
    private final ResourceProvidersClient resourceProviders;

    /**
     * Gets the ResourceProvidersClient object to access its operations.
     * 
     * @return the ResourceProvidersClient object.
     */
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    /**
     * The ManagedEnvironmentsClient object to access its operations.
     */
    private final ManagedEnvironmentsClient managedEnvironments;

    /**
     * Gets the ManagedEnvironmentsClient object to access its operations.
     * 
     * @return the ManagedEnvironmentsClient object.
     */
    public ManagedEnvironmentsClient getManagedEnvironments() {
        return this.managedEnvironments;
    }

    /**
     * The CertificatesClient object to access its operations.
     */
    private final CertificatesClient certificates;

    /**
     * Gets the CertificatesClient object to access its operations.
     * 
     * @return the CertificatesClient object.
     */
    public CertificatesClient getCertificates() {
        return this.certificates;
    }

    /**
     * The ManagedCertificatesClient object to access its operations.
     */
    private final ManagedCertificatesClient managedCertificates;

    /**
     * Gets the ManagedCertificatesClient object to access its operations.
     * 
     * @return the ManagedCertificatesClient object.
     */
    public ManagedCertificatesClient getManagedCertificates() {
        return this.managedCertificates;
    }

    /**
     * The NamespacesClient object to access its operations.
     */
    private final NamespacesClient namespaces;

    /**
     * Gets the NamespacesClient object to access its operations.
     * 
     * @return the NamespacesClient object.
     */
    public NamespacesClient getNamespaces() {
        return this.namespaces;
    }

    /**
     * The ManagedEnvironmentPrivateEndpointConnectionsClient object to access its operations.
     */
    private final ManagedEnvironmentPrivateEndpointConnectionsClient managedEnvironmentPrivateEndpointConnections;

    /**
     * Gets the ManagedEnvironmentPrivateEndpointConnectionsClient object to access its operations.
     * 
     * @return the ManagedEnvironmentPrivateEndpointConnectionsClient object.
     */
    public ManagedEnvironmentPrivateEndpointConnectionsClient getManagedEnvironmentPrivateEndpointConnections() {
        return this.managedEnvironmentPrivateEndpointConnections;
    }

    /**
     * The ManagedEnvironmentPrivateLinkResourcesClient object to access its operations.
     */
    private final ManagedEnvironmentPrivateLinkResourcesClient managedEnvironmentPrivateLinkResources;

    /**
     * Gets the ManagedEnvironmentPrivateLinkResourcesClient object to access its operations.
     * 
     * @return the ManagedEnvironmentPrivateLinkResourcesClient object.
     */
    public ManagedEnvironmentPrivateLinkResourcesClient getManagedEnvironmentPrivateLinkResources() {
        return this.managedEnvironmentPrivateLinkResources;
    }

    /**
     * The DaprComponentResiliencyPoliciesClient object to access its operations.
     */
    private final DaprComponentResiliencyPoliciesClient daprComponentResiliencyPolicies;

    /**
     * Gets the DaprComponentResiliencyPoliciesClient object to access its operations.
     * 
     * @return the DaprComponentResiliencyPoliciesClient object.
     */
    public DaprComponentResiliencyPoliciesClient getDaprComponentResiliencyPolicies() {
        return this.daprComponentResiliencyPolicies;
    }

    /**
     * The DaprComponentsClient object to access its operations.
     */
    private final DaprComponentsClient daprComponents;

    /**
     * Gets the DaprComponentsClient object to access its operations.
     * 
     * @return the DaprComponentsClient object.
     */
    public DaprComponentsClient getDaprComponents() {
        return this.daprComponents;
    }

    /**
     * The DaprSubscriptionsClient object to access its operations.
     */
    private final DaprSubscriptionsClient daprSubscriptions;

    /**
     * Gets the DaprSubscriptionsClient object to access its operations.
     * 
     * @return the DaprSubscriptionsClient object.
     */
    public DaprSubscriptionsClient getDaprSubscriptions() {
        return this.daprSubscriptions;
    }

    /**
     * The ManagedEnvironmentsStoragesClient object to access its operations.
     */
    private final ManagedEnvironmentsStoragesClient managedEnvironmentsStorages;

    /**
     * Gets the ManagedEnvironmentsStoragesClient object to access its operations.
     * 
     * @return the ManagedEnvironmentsStoragesClient object.
     */
    public ManagedEnvironmentsStoragesClient getManagedEnvironmentsStorages() {
        return this.managedEnvironmentsStorages;
    }

    /**
     * The ContainerAppsSourceControlsClient object to access its operations.
     */
    private final ContainerAppsSourceControlsClient containerAppsSourceControls;

    /**
     * Gets the ContainerAppsSourceControlsClient object to access its operations.
     * 
     * @return the ContainerAppsSourceControlsClient object.
     */
    public ContainerAppsSourceControlsClient getContainerAppsSourceControls() {
        return this.containerAppsSourceControls;
    }

    /**
     * The UsagesClient object to access its operations.
     */
    private final UsagesClient usages;

    /**
     * Gets the UsagesClient object to access its operations.
     * 
     * @return the UsagesClient object.
     */
    public UsagesClient getUsages() {
        return this.usages;
    }

    /**
     * The ManagedEnvironmentUsagesClient object to access its operations.
     */
    private final ManagedEnvironmentUsagesClient managedEnvironmentUsages;

    /**
     * Gets the ManagedEnvironmentUsagesClient object to access its operations.
     * 
     * @return the ManagedEnvironmentUsagesClient object.
     */
    public ManagedEnvironmentUsagesClient getManagedEnvironmentUsages() {
        return this.managedEnvironmentUsages;
    }

    /**
     * The FunctionsExtensionsClient object to access its operations.
     */
    private final FunctionsExtensionsClient functionsExtensions;

    /**
     * Gets the FunctionsExtensionsClient object to access its operations.
     * 
     * @return the FunctionsExtensionsClient object.
     */
    public FunctionsExtensionsClient getFunctionsExtensions() {
        return this.functionsExtensions;
    }

    /**
     * The LogicAppsClient object to access its operations.
     */
    private final LogicAppsClient logicApps;

    /**
     * Gets the LogicAppsClient object to access its operations.
     * 
     * @return the LogicAppsClient object.
     */
    public LogicAppsClient getLogicApps() {
        return this.logicApps;
    }

    /**
     * The ContainerAppsSessionPoolsClient object to access its operations.
     */
    private final ContainerAppsSessionPoolsClient containerAppsSessionPools;

    /**
     * Gets the ContainerAppsSessionPoolsClient object to access its operations.
     * 
     * @return the ContainerAppsSessionPoolsClient object.
     */
    public ContainerAppsSessionPoolsClient getContainerAppsSessionPools() {
        return this.containerAppsSessionPools;
    }

    /**
     * Initializes an instance of ContainerAppsApiClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param subscriptionId The ID of the target subscription. The value must be an UUID.
     * @param endpoint server parameter.
     */
    ContainerAppsApiClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter,
        Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2024-02-02-preview";
        this.appResiliencies = new AppResilienciesClientImpl(this);
        this.containerAppsAuthConfigs = new ContainerAppsAuthConfigsClientImpl(this);
        this.availableWorkloadProfiles = new AvailableWorkloadProfilesClientImpl(this);
        this.billingMeters = new BillingMetersClientImpl(this);
        this.builders = new BuildersClientImpl(this);
        this.buildsByBuilderResources = new BuildsByBuilderResourcesClientImpl(this);
        this.builds = new BuildsClientImpl(this);
        this.buildAuthTokens = new BuildAuthTokensClientImpl(this);
        this.connectedEnvironments = new ConnectedEnvironmentsClientImpl(this);
        this.connectedEnvironmentsCertificates = new ConnectedEnvironmentsCertificatesClientImpl(this);
        this.connectedEnvironmentsDaprComponents = new ConnectedEnvironmentsDaprComponentsClientImpl(this);
        this.connectedEnvironmentsStorages = new ConnectedEnvironmentsStoragesClientImpl(this);
        this.containerApps = new ContainerAppsClientImpl(this);
        this.containerAppsRevisions = new ContainerAppsRevisionsClientImpl(this);
        this.containerAppsRevisionReplicas = new ContainerAppsRevisionReplicasClientImpl(this);
        this.containerAppsBuildsByContainerApps = new ContainerAppsBuildsByContainerAppsClientImpl(this);
        this.containerAppsBuilds = new ContainerAppsBuildsClientImpl(this);
        this.containerAppsPatches = new ContainerAppsPatchesClientImpl(this);
        this.containerAppsDiagnostics = new ContainerAppsDiagnosticsClientImpl(this);
        this.managedEnvironmentDiagnostics = new ManagedEnvironmentDiagnosticsClientImpl(this);
        this.managedEnvironmentsDiagnostics = new ManagedEnvironmentsDiagnosticsClientImpl(this);
        this.jobs = new JobsClientImpl(this);
        this.dotNetComponents = new DotNetComponentsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.javaComponents = new JavaComponentsClientImpl(this);
        this.jobsExecutions = new JobsExecutionsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.managedEnvironments = new ManagedEnvironmentsClientImpl(this);
        this.certificates = new CertificatesClientImpl(this);
        this.managedCertificates = new ManagedCertificatesClientImpl(this);
        this.namespaces = new NamespacesClientImpl(this);
        this.managedEnvironmentPrivateEndpointConnections
            = new ManagedEnvironmentPrivateEndpointConnectionsClientImpl(this);
        this.managedEnvironmentPrivateLinkResources = new ManagedEnvironmentPrivateLinkResourcesClientImpl(this);
        this.daprComponentResiliencyPolicies = new DaprComponentResiliencyPoliciesClientImpl(this);
        this.daprComponents = new DaprComponentsClientImpl(this);
        this.daprSubscriptions = new DaprSubscriptionsClientImpl(this);
        this.managedEnvironmentsStorages = new ManagedEnvironmentsStoragesClientImpl(this);
        this.containerAppsSourceControls = new ContainerAppsSourceControlsClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.managedEnvironmentUsages = new ManagedEnvironmentUsagesClientImpl(this);
        this.functionsExtensions = new FunctionsExtensionsClientImpl(this);
        this.logicApps = new LogicAppsClientImpl(this);
        this.containerAppsSessionPools = new ContainerAppsSessionPoolsClientImpl(this);
    }

    /**
     * Gets default client context.
     * 
     * @return the default client context.
     */
    public Context getContext() {
        return Context.NONE;
    }

    /**
     * Merges default client context with provided context.
     * 
     * @param context the context to be merged with default client context.
     * @return the merged context.
     */
    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts(this.getContext(), context);
    }

    /**
     * Gets long running operation result.
     * 
     * @param activationResponse the response of activation operation.
     * @param httpPipeline the http pipeline.
     * @param pollResultType type of poll result.
     * @param finalResultType type of final result.
     * @param context the context shared by all requests.
     * @param <T> type of poll result.
     * @param <U> type of final result.
     * @return poller flux for poll result and final result.
     */
    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse,
        HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create(serializerAdapter, httpPipeline, pollResultType, finalResultType,
            defaultPollInterval, activationResponse, context);
    }

    /**
     * Gets the final result, or an error, based on last async poll response.
     * 
     * @param response the last async poll response.
     * @param <T> type of poll result.
     * @param <U> type of final result.
     * @return the final result, or an error.
     */
    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponse errorResponse = null;
            PollResult.Error lroError = response.getValue().getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(),
                    lroError.getResponseBody());

                errorMessage = response.getValue().getError().getMessage();
                String errorBody = response.getValue().getError().getResponseBody();
                if (errorBody != null) {
                    // try to deserialize error body to ManagementError
                    try {
                        managementError = this.getSerializerAdapter()
                            .deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    } catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning(ioe);
                    }
                }
            } else {
                // fallback to default error message
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                // fallback to default ManagementError
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error(new ManagementException(errorMessage, errorResponse, managementError));
        } else {
            return response.getFinalResult();
        }
    }

    private static final class HttpResponseImpl extends HttpResponse {
        private final int statusCode;

        private final byte[] responseBody;

        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return statusCode;
        }

        public String getHeaderValue(String s) {
            return httpHeaders.getValue(HttpHeaderName.fromString(s));
        }

        public HttpHeaders getHeaders() {
            return httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just(ByteBuffer.wrap(responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just(responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just(new String(responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just(new String(responseBody, charset));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsApiClientImpl.class);
}
