// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsAuthConfigsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.AuthConfigInner;
import com.azure.resourcemanager.appcontainers.models.AuthConfig;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsAuthConfigs;

public final class ContainerAppsAuthConfigsImpl implements ContainerAppsAuthConfigs {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsAuthConfigsImpl.class);

    private final ContainerAppsAuthConfigsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsAuthConfigsImpl(ContainerAppsAuthConfigsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<AuthConfig> listByContainerApp(String resourceGroupName, String containerAppName) {
        PagedIterable<AuthConfigInner> inner
            = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthConfigImpl(inner1, this.manager()));
    }

    public PagedIterable<AuthConfig> listByContainerApp(String resourceGroupName, String containerAppName,
        Context context) {
        PagedIterable<AuthConfigInner> inner
            = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthConfigImpl(inner1, this.manager()));
    }

    public Response<AuthConfig> getWithResponse(String resourceGroupName, String containerAppName,
        String authConfigName, Context context) {
        Response<AuthConfigInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, containerAppName, authConfigName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new AuthConfigImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AuthConfig get(String resourceGroupName, String containerAppName, String authConfigName) {
        AuthConfigInner inner = this.serviceClient().get(resourceGroupName, containerAppName, authConfigName);
        if (inner != null) {
            return new AuthConfigImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String containerAppName, String authConfigName,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, containerAppName, authConfigName, context);
    }

    public void delete(String resourceGroupName, String containerAppName, String authConfigName) {
        this.serviceClient().delete(resourceGroupName, containerAppName, authConfigName);
    }

    public AuthConfig getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = ResourceManagerUtils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, containerAppName, authConfigName, Context.NONE).getValue();
    }

    public Response<AuthConfig> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = ResourceManagerUtils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, containerAppName, authConfigName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = ResourceManagerUtils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, containerAppName, authConfigName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = ResourceManagerUtils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, containerAppName, authConfigName, context);
    }

    private ContainerAppsAuthConfigsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public AuthConfigImpl define(String name) {
        return new AuthConfigImpl(name, this.manager());
    }
}
