// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsBuildsByContainerAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsBuildResourceInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildResource;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildsByContainerApps;

public final class ContainerAppsBuildsByContainerAppsImpl implements ContainerAppsBuildsByContainerApps {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsBuildsByContainerAppsImpl.class);

    private final ContainerAppsBuildsByContainerAppsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsBuildsByContainerAppsImpl(ContainerAppsBuildsByContainerAppsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ContainerAppsBuildResource> list(String resourceGroupName, String containerAppName) {
        PagedIterable<ContainerAppsBuildResourceInner> inner
            = this.serviceClient().list(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ContainerAppsBuildResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ContainerAppsBuildResource> list(String resourceGroupName, String containerAppName,
        Context context) {
        PagedIterable<ContainerAppsBuildResourceInner> inner
            = this.serviceClient().list(resourceGroupName, containerAppName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ContainerAppsBuildResourceImpl(inner1, this.manager()));
    }

    private ContainerAppsBuildsByContainerAppsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
