// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsBuildsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsBuildResourceInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildResource;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuilds;

public final class ContainerAppsBuildsImpl implements ContainerAppsBuilds {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsBuildsImpl.class);

    private final ContainerAppsBuildsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsBuildsImpl(ContainerAppsBuildsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ContainerAppsBuildResource> getWithResponse(String resourceGroupName, String containerAppName,
        String buildName, Context context) {
        Response<ContainerAppsBuildResourceInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, containerAppName, buildName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ContainerAppsBuildResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ContainerAppsBuildResource get(String resourceGroupName, String containerAppName, String buildName) {
        ContainerAppsBuildResourceInner inner
            = this.serviceClient().get(resourceGroupName, containerAppName, buildName);
        if (inner != null) {
            return new ContainerAppsBuildResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String containerAppName, String buildName) {
        this.serviceClient().delete(resourceGroupName, containerAppName, buildName);
    }

    public void delete(String resourceGroupName, String containerAppName, String buildName, Context context) {
        this.serviceClient().delete(resourceGroupName, containerAppName, buildName, context);
    }

    private ContainerAppsBuildsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
