// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.fluent.models.RevisionInner;
import com.azure.resourcemanager.appcontainers.models.ContainerApp;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsDiagnostics;
import com.azure.resourcemanager.appcontainers.models.Diagnostics;
import com.azure.resourcemanager.appcontainers.models.Revision;

public final class ContainerAppsDiagnosticsImpl implements ContainerAppsDiagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsDiagnosticsImpl.class);

    private final ContainerAppsDiagnosticsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsDiagnosticsImpl(ContainerAppsDiagnosticsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<Diagnostics> listDetectors(String resourceGroupName, String containerAppName) {
        PagedIterable<DiagnosticsInner> inner = this.serviceClient().listDetectors(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticsImpl(inner1, this.manager()));
    }

    public PagedIterable<Diagnostics> listDetectors(String resourceGroupName, String containerAppName,
        Context context) {
        PagedIterable<DiagnosticsInner> inner
            = this.serviceClient().listDetectors(resourceGroupName, containerAppName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticsImpl(inner1, this.manager()));
    }

    public Response<Diagnostics> getDetectorWithResponse(String resourceGroupName, String containerAppName,
        String detectorName, Context context) {
        Response<DiagnosticsInner> inner
            = this.serviceClient().getDetectorWithResponse(resourceGroupName, containerAppName, detectorName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DiagnosticsImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Diagnostics getDetector(String resourceGroupName, String containerAppName, String detectorName) {
        DiagnosticsInner inner = this.serviceClient().getDetector(resourceGroupName, containerAppName, detectorName);
        if (inner != null) {
            return new DiagnosticsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<Revision> listRevisions(String resourceGroupName, String containerAppName) {
        PagedIterable<RevisionInner> inner = this.serviceClient().listRevisions(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RevisionImpl(inner1, this.manager()));
    }

    public PagedIterable<Revision> listRevisions(String resourceGroupName, String containerAppName, String filter,
        Context context) {
        PagedIterable<RevisionInner> inner
            = this.serviceClient().listRevisions(resourceGroupName, containerAppName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RevisionImpl(inner1, this.manager()));
    }

    public Response<Revision> getRevisionWithResponse(String resourceGroupName, String containerAppName,
        String revisionName, Context context) {
        Response<RevisionInner> inner
            = this.serviceClient().getRevisionWithResponse(resourceGroupName, containerAppName, revisionName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new RevisionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Revision getRevision(String resourceGroupName, String containerAppName, String revisionName) {
        RevisionInner inner = this.serviceClient().getRevision(resourceGroupName, containerAppName, revisionName);
        if (inner != null) {
            return new RevisionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ContainerApp> getRootWithResponse(String resourceGroupName, String containerAppName,
        Context context) {
        Response<ContainerAppInner> inner
            = this.serviceClient().getRootWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ContainerAppImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ContainerApp getRoot(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().getRoot(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ContainerAppsDiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
