// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppAuthTokenInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.CustomHostnameAnalysisResultInner;
import com.azure.resourcemanager.appcontainers.fluent.models.SecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.models.ContainerApp;
import com.azure.resourcemanager.appcontainers.models.ContainerAppAuthToken;
import com.azure.resourcemanager.appcontainers.models.ContainerApps;
import com.azure.resourcemanager.appcontainers.models.CustomHostnameAnalysisResult;
import com.azure.resourcemanager.appcontainers.models.SecretsCollection;

public final class ContainerAppsImpl implements ContainerApps {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsImpl.class);

    private final ContainerAppsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsImpl(ContainerAppsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ContainerApp> list() {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContainerAppImpl(inner1, this.manager()));
    }

    public PagedIterable<ContainerApp> list(Context context) {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContainerAppImpl(inner1, this.manager()));
    }

    public PagedIterable<ContainerApp> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContainerAppImpl(inner1, this.manager()));
    }

    public PagedIterable<ContainerApp> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContainerAppImpl(inner1, this.manager()));
    }

    public Response<ContainerApp> getByResourceGroupWithResponse(String resourceGroupName, String containerAppName,
        Context context) {
        Response<ContainerAppInner> inner
            = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ContainerAppImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ContainerApp getByResourceGroup(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void deleteByResourceGroup(String resourceGroupName, String containerAppName) {
        this.serviceClient().delete(resourceGroupName, containerAppName);
    }

    public void delete(String resourceGroupName, String containerAppName, Context context) {
        this.serviceClient().delete(resourceGroupName, containerAppName, context);
    }

    public Response<CustomHostnameAnalysisResult> listCustomHostnameAnalysisWithResponse(String resourceGroupName,
        String containerAppName, String customHostname, Context context) {
        Response<CustomHostnameAnalysisResultInner> inner = this.serviceClient()
            .listCustomHostnameAnalysisWithResponse(resourceGroupName, containerAppName, customHostname, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CustomHostnameAnalysisResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CustomHostnameAnalysisResult listCustomHostnameAnalysis(String resourceGroupName, String containerAppName) {
        CustomHostnameAnalysisResultInner inner
            = this.serviceClient().listCustomHostnameAnalysis(resourceGroupName, containerAppName);
        if (inner != null) {
            return new CustomHostnameAnalysisResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<SecretsCollection> listSecretsWithResponse(String resourceGroupName, String containerAppName,
        Context context) {
        Response<SecretsCollectionInner> inner
            = this.serviceClient().listSecretsWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new SecretsCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SecretsCollection listSecrets(String resourceGroupName, String containerAppName) {
        SecretsCollectionInner inner = this.serviceClient().listSecrets(resourceGroupName, containerAppName);
        if (inner != null) {
            return new SecretsCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ContainerAppAuthToken> getAuthTokenWithResponse(String resourceGroupName, String containerAppName,
        Context context) {
        Response<ContainerAppAuthTokenInner> inner
            = this.serviceClient().getAuthTokenWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ContainerAppAuthTokenImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ContainerAppAuthToken getAuthToken(String resourceGroupName, String containerAppName) {
        ContainerAppAuthTokenInner inner = this.serviceClient().getAuthToken(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppAuthTokenImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ContainerApp start(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().start(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ContainerApp start(String resourceGroupName, String containerAppName, Context context) {
        ContainerAppInner inner = this.serviceClient().start(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ContainerApp stop(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().stop(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ContainerApp stop(String resourceGroupName, String containerAppName, Context context) {
        ContainerAppInner inner = this.serviceClient().stop(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ContainerApp getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, containerAppName, Context.NONE).getValue();
    }

    public Response<ContainerApp> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, containerAppName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        this.delete(resourceGroupName, containerAppName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        this.delete(resourceGroupName, containerAppName, context);
    }

    private ContainerAppsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public ContainerAppImpl define(String name) {
        return new ContainerAppImpl(name, this.manager());
    }
}
