// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsPatchesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsPatchResourceInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsPatches;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsPatchResource;
import com.azure.resourcemanager.appcontainers.models.PatchSkipConfig;

public final class ContainerAppsPatchesImpl implements ContainerAppsPatches {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsPatchesImpl.class);

    private final ContainerAppsPatchesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsPatchesImpl(ContainerAppsPatchesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ContainerAppsPatchResource> listByContainerApp(String resourceGroupName,
        String containerAppName) {
        PagedIterable<ContainerAppsPatchResourceInner> inner
            = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ContainerAppsPatchResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ContainerAppsPatchResource> listByContainerApp(String resourceGroupName,
        String containerAppName, String filter, Context context) {
        PagedIterable<ContainerAppsPatchResourceInner> inner
            = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName, filter, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ContainerAppsPatchResourceImpl(inner1, this.manager()));
    }

    public Response<ContainerAppsPatchResource> getWithResponse(String resourceGroupName, String containerAppName,
        String patchName, Context context) {
        Response<ContainerAppsPatchResourceInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, containerAppName, patchName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ContainerAppsPatchResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ContainerAppsPatchResource get(String resourceGroupName, String containerAppName, String patchName) {
        ContainerAppsPatchResourceInner inner
            = this.serviceClient().get(resourceGroupName, containerAppName, patchName);
        if (inner != null) {
            return new ContainerAppsPatchResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String containerAppName, String patchName) {
        this.serviceClient().delete(resourceGroupName, containerAppName, patchName);
    }

    public void delete(String resourceGroupName, String containerAppName, String patchName, Context context) {
        this.serviceClient().delete(resourceGroupName, containerAppName, patchName, context);
    }

    public void skipConfigure(String resourceGroupName, String containerAppName, String patchName,
        PatchSkipConfig patchSkipConfig) {
        this.serviceClient().skipConfigure(resourceGroupName, containerAppName, patchName, patchSkipConfig);
    }

    public void skipConfigure(String resourceGroupName, String containerAppName, String patchName,
        PatchSkipConfig patchSkipConfig, Context context) {
        this.serviceClient().skipConfigure(resourceGroupName, containerAppName, patchName, patchSkipConfig, context);
    }

    public ContainerAppsPatchResource apply(String resourceGroupName, String containerAppName, String patchName) {
        ContainerAppsPatchResourceInner inner
            = this.serviceClient().apply(resourceGroupName, containerAppName, patchName);
        if (inner != null) {
            return new ContainerAppsPatchResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ContainerAppsPatchResource apply(String resourceGroupName, String containerAppName, String patchName,
        Context context) {
        ContainerAppsPatchResourceInner inner
            = this.serviceClient().apply(resourceGroupName, containerAppName, patchName, context);
        if (inner != null) {
            return new ContainerAppsPatchResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ContainerAppsPatchesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
