// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionReplicasClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsRevisionReplicas;
import com.azure.resourcemanager.appcontainers.models.Replica;
import com.azure.resourcemanager.appcontainers.models.ReplicaCollection;

public final class ContainerAppsRevisionReplicasImpl implements ContainerAppsRevisionReplicas {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsRevisionReplicasImpl.class);

    private final ContainerAppsRevisionReplicasClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsRevisionReplicasImpl(ContainerAppsRevisionReplicasClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Replica> getReplicaWithResponse(String resourceGroupName, String containerAppName,
        String revisionName, String replicaName, Context context) {
        Response<ReplicaInner> inner = this.serviceClient()
            .getReplicaWithResponse(resourceGroupName, containerAppName, revisionName, replicaName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ReplicaImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Replica getReplica(String resourceGroupName, String containerAppName, String revisionName,
        String replicaName) {
        ReplicaInner inner
            = this.serviceClient().getReplica(resourceGroupName, containerAppName, revisionName, replicaName);
        if (inner != null) {
            return new ReplicaImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ReplicaCollection> listReplicasWithResponse(String resourceGroupName, String containerAppName,
        String revisionName, Context context) {
        Response<ReplicaCollectionInner> inner
            = this.serviceClient().listReplicasWithResponse(resourceGroupName, containerAppName, revisionName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ReplicaCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ReplicaCollection listReplicas(String resourceGroupName, String containerAppName, String revisionName) {
        ReplicaCollectionInner inner
            = this.serviceClient().listReplicas(resourceGroupName, containerAppName, revisionName);
        if (inner != null) {
            return new ReplicaCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ContainerAppsRevisionReplicasClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
