// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsSessionPoolsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appcontainers.models.SessionPoolCollection;
import com.azure.resourcemanager.appcontainers.models.SessionPoolUpdatableProperties;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ContainerAppsSessionPoolsClient.
 */
public final class ContainerAppsSessionPoolsClientImpl implements ContainerAppsSessionPoolsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ContainerAppsSessionPoolsService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerAppsApiClientImpl client;

    /**
     * Initializes an instance of ContainerAppsSessionPoolsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ContainerAppsSessionPoolsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = RestProxy.create(ContainerAppsSessionPoolsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerAppsApiClientContainerAppsSessionPools to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerAppsApiClie")
    public interface ContainerAppsSessionPoolsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.App/sessionPools")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SessionPoolCollection>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/sessionPools")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SessionPoolCollection>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/sessionPools/{sessionPoolName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SessionPoolInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("sessionPoolName") String sessionPoolName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/sessionPools/{sessionPoolName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("sessionPoolName") String sessionPoolName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SessionPoolInner sessionPoolEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/sessionPools/{sessionPoolName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("sessionPoolName") String sessionPoolName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SessionPoolUpdatableProperties sessionPoolEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/sessionPools/{sessionPoolName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("sessionPoolName") String sessionPoolName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SessionPoolCollection>> listBySubscriptionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SessionPoolCollection>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get the session pools in a given subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<SessionPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the session pools in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the session pools in a given subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SessionPoolInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * Get the session pools in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SessionPoolInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get the session pools in a given subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SessionPoolInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get the session pools in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SessionPoolInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<SessionPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SessionPoolInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SessionPoolInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SessionPoolInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SessionPoolInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SessionPoolInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String sessionPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, sessionPoolName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SessionPoolInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String sessionPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            sessionPoolName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SessionPoolInner> getByResourceGroupAsync(String resourceGroupName, String sessionPoolName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, sessionPoolName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SessionPoolInner> getByResourceGroupWithResponse(String resourceGroupName, String sessionPoolName,
        Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, sessionPoolName, context).block();
    }

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SessionPoolInner getByResourceGroup(String resourceGroupName, String sessionPoolName) {
        return getByResourceGroupWithResponse(resourceGroupName, sessionPoolName, Context.NONE).getValue();
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String sessionPoolName, SessionPoolInner sessionPoolEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        if (sessionPoolEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolEnvelope is required and cannot be null."));
        } else {
            sessionPoolEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, sessionPoolName, this.client.getApiVersion(), sessionPoolEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String sessionPoolName, SessionPoolInner sessionPoolEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        if (sessionPoolEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolEnvelope is required and cannot be null."));
        } else {
            sessionPoolEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            sessionPoolName, this.client.getApiVersion(), sessionPoolEnvelope, accept, context);
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SessionPoolInner>, SessionPoolInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String sessionPoolName, SessionPoolInner sessionPoolEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope);
        return this.client.<SessionPoolInner, SessionPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            SessionPoolInner.class, SessionPoolInner.class, this.client.getContext());
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SessionPoolInner>, SessionPoolInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String sessionPoolName, SessionPoolInner sessionPoolEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context);
        return this.client.<SessionPoolInner, SessionPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            SessionPoolInner.class, SessionPoolInner.class, context);
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginCreateOrUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolInner sessionPoolEnvelope) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope).getSyncPoller();
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginCreateOrUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolInner sessionPoolEnvelope, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context)
            .getSyncPoller();
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SessionPoolInner> createOrUpdateAsync(String resourceGroupName, String sessionPoolName,
        SessionPoolInner sessionPoolEnvelope) {
        return beginCreateOrUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SessionPoolInner> createOrUpdateAsync(String resourceGroupName, String sessionPoolName,
        SessionPoolInner sessionPoolEnvelope, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SessionPoolInner createOrUpdate(String resourceGroupName, String sessionPoolName,
        SessionPoolInner sessionPoolEnvelope) {
        return createOrUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope).block();
    }

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SessionPoolInner createOrUpdate(String resourceGroupName, String sessionPoolName,
        SessionPoolInner sessionPoolEnvelope, Context context) {
        return createOrUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context).block();
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        if (sessionPoolEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolEnvelope is required and cannot be null."));
        } else {
            sessionPoolEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, sessionPoolName, this.client.getApiVersion(), sessionPoolEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        if (sessionPoolEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolEnvelope is required and cannot be null."));
        } else {
            sessionPoolEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            sessionPoolName, this.client.getApiVersion(), sessionPoolEnvelope, accept, context);
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SessionPoolInner>, SessionPoolInner> beginUpdateAsync(String resourceGroupName,
        String sessionPoolName, SessionPoolUpdatableProperties sessionPoolEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope);
        return this.client.<SessionPoolInner, SessionPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            SessionPoolInner.class, SessionPoolInner.class, this.client.getContext());
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SessionPoolInner>, SessionPoolInner> beginUpdateAsync(String resourceGroupName,
        String sessionPoolName, SessionPoolUpdatableProperties sessionPoolEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context);
        return this.client.<SessionPoolInner, SessionPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            SessionPoolInner.class, SessionPoolInner.class, context);
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolUpdatableProperties sessionPoolEnvelope) {
        return this.beginUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope).getSyncPoller();
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolUpdatableProperties sessionPoolEnvelope, Context context) {
        return this.beginUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context).getSyncPoller();
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SessionPoolInner> updateAsync(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope) {
        return beginUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SessionPoolInner> updateAsync(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope, Context context) {
        return beginUpdateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SessionPoolInner update(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope) {
        return updateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope).block();
    }

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SessionPoolInner update(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope, Context context) {
        return updateAsync(resourceGroupName, sessionPoolName, sessionPoolEnvelope, context).block();
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String sessionPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, sessionPoolName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String sessionPoolName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sessionPoolName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter sessionPoolName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            sessionPoolName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String sessionPoolName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, sessionPoolName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String sessionPoolName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, sessionPoolName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sessionPoolName) {
        return this.beginDeleteAsync(resourceGroupName, sessionPoolName).getSyncPoller();
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sessionPoolName,
        Context context) {
        return this.beginDeleteAsync(resourceGroupName, sessionPoolName, context).getSyncPoller();
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String sessionPoolName) {
        return beginDeleteAsync(resourceGroupName, sessionPoolName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String sessionPoolName, Context context) {
        return beginDeleteAsync(resourceGroupName, sessionPoolName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sessionPoolName) {
        deleteAsync(resourceGroupName, sessionPoolName).block();
    }

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sessionPoolName, Context context) {
        deleteAsync(resourceGroupName, sessionPoolName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return session pool collection Azure resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<SessionPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return session pool collection Azure resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listBySubscriptionNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return session pool collection Azure resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<SessionPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return session pool collection Azure resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SessionPoolInner>> listByResourceGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
