// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsSessionPoolsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsSessionPools;
import com.azure.resourcemanager.appcontainers.models.SessionPool;

public final class ContainerAppsSessionPoolsImpl implements ContainerAppsSessionPools {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsSessionPoolsImpl.class);

    private final ContainerAppsSessionPoolsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ContainerAppsSessionPoolsImpl(ContainerAppsSessionPoolsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<SessionPool> list() {
        PagedIterable<SessionPoolInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionPoolImpl(inner1, this.manager()));
    }

    public PagedIterable<SessionPool> list(Context context) {
        PagedIterable<SessionPoolInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionPoolImpl(inner1, this.manager()));
    }

    public PagedIterable<SessionPool> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SessionPoolInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionPoolImpl(inner1, this.manager()));
    }

    public PagedIterable<SessionPool> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SessionPoolInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionPoolImpl(inner1, this.manager()));
    }

    public Response<SessionPool> getByResourceGroupWithResponse(String resourceGroupName, String sessionPoolName,
        Context context) {
        Response<SessionPoolInner> inner
            = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, sessionPoolName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new SessionPoolImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SessionPool getByResourceGroup(String resourceGroupName, String sessionPoolName) {
        SessionPoolInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, sessionPoolName);
        if (inner != null) {
            return new SessionPoolImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void deleteByResourceGroup(String resourceGroupName, String sessionPoolName) {
        this.serviceClient().delete(resourceGroupName, sessionPoolName);
    }

    public void delete(String resourceGroupName, String sessionPoolName, Context context) {
        this.serviceClient().delete(resourceGroupName, sessionPoolName, context);
    }

    public SessionPool getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sessionPoolName = ResourceManagerUtils.getValueFromIdByName(id, "sessionPools");
        if (sessionPoolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'sessionPools'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, sessionPoolName, Context.NONE).getValue();
    }

    public Response<SessionPool> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sessionPoolName = ResourceManagerUtils.getValueFromIdByName(id, "sessionPools");
        if (sessionPoolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'sessionPools'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, sessionPoolName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sessionPoolName = ResourceManagerUtils.getValueFromIdByName(id, "sessionPools");
        if (sessionPoolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'sessionPools'.", id)));
        }
        this.delete(resourceGroupName, sessionPoolName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sessionPoolName = ResourceManagerUtils.getValueFromIdByName(id, "sessionPools");
        if (sessionPoolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'sessionPools'.", id)));
        }
        this.delete(resourceGroupName, sessionPoolName, context);
    }

    private ContainerAppsSessionPoolsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public SessionPoolImpl define(String name) {
        return new SessionPoolImpl(name, this.manager());
    }
}
