// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.resourcemanager.appcontainers.fluent.models.CustomHostnameAnalysisResultInner;
import com.azure.resourcemanager.appcontainers.models.CustomHostnameAnalysisResult;
import com.azure.resourcemanager.appcontainers.models.CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo;
import com.azure.resourcemanager.appcontainers.models.DnsVerificationTestResult;
import java.util.Collections;
import java.util.List;

public final class CustomHostnameAnalysisResultImpl implements CustomHostnameAnalysisResult {
    private CustomHostnameAnalysisResultInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    CustomHostnameAnalysisResultImpl(CustomHostnameAnalysisResultInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String hostname() {
        return this.innerModel().hostname();
    }

    public Boolean isHostnameAlreadyVerified() {
        return this.innerModel().isHostnameAlreadyVerified();
    }

    public DnsVerificationTestResult customDomainVerificationTest() {
        return this.innerModel().customDomainVerificationTest();
    }

    public CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo customDomainVerificationFailureInfo() {
        return this.innerModel().customDomainVerificationFailureInfo();
    }

    public Boolean hasConflictOnManagedEnvironment() {
        return this.innerModel().hasConflictOnManagedEnvironment();
    }

    public Boolean conflictWithEnvironmentCustomDomain() {
        return this.innerModel().conflictWithEnvironmentCustomDomain();
    }

    public String conflictingContainerAppResourceId() {
        return this.innerModel().conflictingContainerAppResourceId();
    }

    public List<String> cNameRecords() {
        List<String> inner = this.innerModel().cNameRecords();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<String> txtRecords() {
        List<String> inner = this.innerModel().txtRecords();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<String> aRecords() {
        List<String> inner = this.innerModel().aRecords();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<String> alternateCNameRecords() {
        List<String> inner = this.innerModel().alternateCNameRecords();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<String> alternateTxtRecords() {
        List<String> inner = this.innerModel().alternateTxtRecords();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public CustomHostnameAnalysisResultInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
