// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentResiliencyPoliciesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentResiliencyPolicyInner;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicies;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicy;

public final class DaprComponentResiliencyPoliciesImpl implements DaprComponentResiliencyPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(DaprComponentResiliencyPoliciesImpl.class);

    private final DaprComponentResiliencyPoliciesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public DaprComponentResiliencyPoliciesImpl(DaprComponentResiliencyPoliciesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<DaprComponentResiliencyPolicy> list(String resourceGroupName, String environmentName,
        String componentName) {
        PagedIterable<DaprComponentResiliencyPolicyInner> inner
            = this.serviceClient().list(resourceGroupName, environmentName, componentName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new DaprComponentResiliencyPolicyImpl(inner1, this.manager()));
    }

    public PagedIterable<DaprComponentResiliencyPolicy> list(String resourceGroupName, String environmentName,
        String componentName, Context context) {
        PagedIterable<DaprComponentResiliencyPolicyInner> inner
            = this.serviceClient().list(resourceGroupName, environmentName, componentName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new DaprComponentResiliencyPolicyImpl(inner1, this.manager()));
    }

    public Response<DaprComponentResiliencyPolicy> getWithResponse(String resourceGroupName, String environmentName,
        String componentName, String name, Context context) {
        Response<DaprComponentResiliencyPolicyInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, environmentName, componentName, name, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DaprComponentResiliencyPolicyImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public DaprComponentResiliencyPolicy get(String resourceGroupName, String environmentName, String componentName,
        String name) {
        DaprComponentResiliencyPolicyInner inner
            = this.serviceClient().get(resourceGroupName, environmentName, componentName, name);
        if (inner != null) {
            return new DaprComponentResiliencyPolicyImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String componentName,
        String name, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, environmentName, componentName, name, context);
    }

    public void delete(String resourceGroupName, String environmentName, String componentName, String name) {
        this.serviceClient().delete(resourceGroupName, environmentName, componentName, name);
    }

    public DaprComponentResiliencyPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, componentName, name, Context.NONE).getValue();
    }

    public Response<DaprComponentResiliencyPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, componentName, name, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, componentName, name, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String componentName = ResourceManagerUtils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, componentName, name, context);
    }

    private DaprComponentResiliencyPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public DaprComponentResiliencyPolicyImpl define(String name) {
        return new DaprComponentResiliencyPolicyImpl(name, this.manager());
    }
}
