// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentResiliencyPolicyInner;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicy;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicyConfiguration;

public final class DaprComponentResiliencyPolicyImpl implements DaprComponentResiliencyPolicy,
    DaprComponentResiliencyPolicy.Definition, DaprComponentResiliencyPolicy.Update {
    private DaprComponentResiliencyPolicyInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public DaprComponentResiliencyPolicyConfiguration inboundPolicy() {
        return this.innerModel().inboundPolicy();
    }

    public DaprComponentResiliencyPolicyConfiguration outboundPolicy() {
        return this.innerModel().outboundPolicy();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public DaprComponentResiliencyPolicyInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String environmentName;

    private String componentName;

    private String name;

    public DaprComponentResiliencyPolicyImpl withExistingDaprComponent(String resourceGroupName, String environmentName,
        String componentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        this.componentName = componentName;
        return this;
    }

    public DaprComponentResiliencyPolicy create() {
        this.innerObject = serviceManager.serviceClient()
            .getDaprComponentResiliencyPolicies()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, componentName, name, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public DaprComponentResiliencyPolicy create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDaprComponentResiliencyPolicies()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, componentName, name, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    DaprComponentResiliencyPolicyImpl(String name,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new DaprComponentResiliencyPolicyInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    public DaprComponentResiliencyPolicyImpl update() {
        return this;
    }

    public DaprComponentResiliencyPolicy apply() {
        this.innerObject = serviceManager.serviceClient()
            .getDaprComponentResiliencyPolicies()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, componentName, name, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public DaprComponentResiliencyPolicy apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDaprComponentResiliencyPolicies()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, componentName, name, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    DaprComponentResiliencyPolicyImpl(DaprComponentResiliencyPolicyInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.componentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "daprComponents");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resiliencyPolicies");
    }

    public DaprComponentResiliencyPolicy refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getDaprComponentResiliencyPolicies()
            .getWithResponse(resourceGroupName, environmentName, componentName, name, Context.NONE)
            .getValue();
        return this;
    }

    public DaprComponentResiliencyPolicy refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDaprComponentResiliencyPolicies()
            .getWithResponse(resourceGroupName, environmentName, componentName, name, context)
            .getValue();
        return this;
    }

    public DaprComponentResiliencyPolicyImpl
        withInboundPolicy(DaprComponentResiliencyPolicyConfiguration inboundPolicy) {
        this.innerModel().withInboundPolicy(inboundPolicy);
        return this;
    }

    public DaprComponentResiliencyPolicyImpl
        withOutboundPolicy(DaprComponentResiliencyPolicyConfiguration outboundPolicy) {
        this.innerModel().withOutboundPolicy(outboundPolicy);
        return this;
    }
}
