// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.models.DaprComponent;
import com.azure.resourcemanager.appcontainers.models.DaprComponents;
import com.azure.resourcemanager.appcontainers.models.DaprSecretsCollection;

public final class DaprComponentsImpl implements DaprComponents {
    private static final ClientLogger LOGGER = new ClientLogger(DaprComponentsImpl.class);

    private final DaprComponentsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public DaprComponentsImpl(DaprComponentsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName) {
        PagedIterable<DaprComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DaprComponentImpl(inner1, this.manager()));
    }

    public PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<DaprComponentInner> inner
            = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DaprComponentImpl(inner1, this.manager()));
    }

    public Response<DaprComponent> getWithResponse(String resourceGroupName, String environmentName,
        String componentName, Context context) {
        Response<DaprComponentInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, environmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DaprComponentImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public DaprComponent get(String resourceGroupName, String environmentName, String componentName) {
        DaprComponentInner inner = this.serviceClient().get(resourceGroupName, environmentName, componentName);
        if (inner != null) {
            return new DaprComponentImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<DaprComponent> createOrUpdateWithResponse(String resourceGroupName, String environmentName,
        String componentName, DaprComponentInner daprComponentEnvelope, Context context) {
        Response<DaprComponentInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, componentName, daprComponentEnvelope,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DaprComponentImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public DaprComponent createOrUpdate(String resourceGroupName, String environmentName, String componentName,
        DaprComponentInner daprComponentEnvelope) {
        DaprComponentInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, environmentName, componentName, daprComponentEnvelope);
        if (inner != null) {
            return new DaprComponentImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String componentName,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, componentName, context);
    }

    public void delete(String resourceGroupName, String environmentName, String componentName) {
        this.serviceClient().delete(resourceGroupName, environmentName, componentName);
    }

    public Response<DaprSecretsCollection> listSecretsWithResponse(String resourceGroupName, String environmentName,
        String componentName, Context context) {
        Response<DaprSecretsCollectionInner> inner
            = this.serviceClient().listSecretsWithResponse(resourceGroupName, environmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DaprSecretsCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public DaprSecretsCollection listSecrets(String resourceGroupName, String environmentName, String componentName) {
        DaprSecretsCollectionInner inner
            = this.serviceClient().listSecrets(resourceGroupName, environmentName, componentName);
        if (inner != null) {
            return new DaprSecretsCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private DaprComponentsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
